/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block;

import alabaster.hearthandharvest.common.block.entity.JugBlockEntity;
import alabaster.hearthandharvest.common.registry.HHModBlockEntities;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class JugBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public JugBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        FluidState fluid = level.m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof JugBlockEntity) {
            JugBlockEntity jug = (JugBlockEntity)blockEntity;
            int amount = jug.getFluidAmount();
            int bucketSize = 1000;
            int signal = amount / bucketSize;
            return Math.min(signal, 8);
        }
        return 0;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof JugBlockEntity) {
            JugBlockEntity tile = (JugBlockEntity)((Object)object);
            return Collections.singletonList(JugBlock.saveTileToItem(tile));
        }
        return super.m_49635_(state, builder);
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (blockEntity instanceof JugBlockEntity) {
            JugBlockEntity tile = (JugBlockEntity)blockEntity;
            return JugBlock.saveTileToItem(tile);
        }
        return super.m_7397_(blockGetter, blockPos, blockState);
    }

    public static ItemStack saveTileToItem(BlockEntity tile) {
        Block block = tile.m_58900_().m_60734_();
        ItemStack stack = new ItemStack((ItemLike)block.m_5456_());
        tile.m_187476_(stack);
        return stack;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof JugBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        JugBlockEntity jug = (JugBlockEntity)blockEntity;
        ItemStack stack = player.m_21120_(hand);
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int filled;
            FluidStack simulatedFill;
            int filled2;
            boolean didSomething = false;
            FluidStack simulatedDrain = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!simulatedDrain.isEmpty() && (filled2 = jug.fill(simulatedDrain, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                handler.drain(filled2, IFluidHandler.FluidAction.EXECUTE);
                level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_21008_(hand, handler.getContainer());
                didSomething = true;
            }
            if (!didSomething && !(simulatedFill = jug.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && (filled = handler.fill(simulatedFill, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                jug.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_21008_(hand, handler.getContainer());
            }
        });
        return InteractionResult.CONSUME;
    }

    @Nullable
    public JugBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (JugBlockEntity)((BlockEntityType)HHModBlockEntities.JUG.get()).m_155264_(pos, state);
    }
}

