/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block;

import alabaster.hearthandharvest.common.block.entity.WineRackBlockEntity;
import alabaster.hearthandharvest.common.block.entity.container.WineRackSlotHelper;
import alabaster.hearthandharvest.common.tag.HHModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WineRackBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public WineRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (direction == Direction.NORTH) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
        }
        if (direction == Direction.EAST) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
        }
        if (direction == Direction.SOUTH) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
        }
        if (direction == Direction.WEST) {
            return Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return super.m_5940_(state, level, pos, context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof WineRackBlockEntity)) {
            return InteractionResult.PASS;
        }
        WineRackBlockEntity rack = (WineRackBlockEntity)blockEntity;
        int slot = WineRackSlotHelper.getSlotFromHit(state, hit);
        if (slot < 0 || slot >= rack.m_6643_()) {
            return InteractionResult.PASS;
        }
        ItemStack current = rack.m_8020_(slot);
        if (current.m_41619_()) {
            if (!heldStack.m_41619_() && !(heldStack.m_41720_() instanceof BlockItem) && heldStack.m_204117_(HHModTags.WINE_BOTTLES)) {
                ItemStack placed = heldStack.m_255036_(1);
                rack.m_6836_(slot, placed);
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
                level.m_7260_(pos, state, state, 3);
                return InteractionResult.SUCCESS;
            }
        } else {
            if (!level.f_46443_) {
                player.m_36356_(current.m_41777_());
            }
            rack.m_6836_(slot, ItemStack.f_41583_);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof WineRackBlockEntity)) {
            return 0;
        }
        WineRackBlockEntity rack = (WineRackBlockEntity)blockEntity;
        int filledSlots = 0;
        for (int i = 0; i < rack.m_6643_(); ++i) {
            if (rack.m_8020_(i).m_41619_()) continue;
            ++filledSlots;
        }
        return Math.min(filledSlots, 15);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        if (blockEntity instanceof WineRackBlockEntity) {
            WineRackBlockEntity rack = (WineRackBlockEntity)blockEntity;
            for (int i = 0; i < rack.m_6643_(); ++i) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)rack.m_8020_(i));
            }
        }
        super.m_6240_(level, player, pos, state, blockEntity, tool);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WineRackBlockEntity(pos, state);
    }
}

