/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block.entity.container;

import alabaster.hearthandharvest.HearthAndHarvest;
import alabaster.hearthandharvest.common.block.entity.CaskBlockEntity;
import alabaster.hearthandharvest.common.block.entity.container.CaskResultSlot;
import alabaster.hearthandharvest.common.registry.HHModBlocks;
import alabaster.hearthandharvest.common.registry.HHModMenuTypes;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CaskMenu
extends RecipeBookMenu<RecipeWrapper> {
    public final CaskBlockEntity blockEntity;
    public final ItemStackHandler inventory;
    private final ContainerData caskData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public CaskMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CaskMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public CaskMenu(int windowId, Inventory playerInventory, CaskBlockEntity blockEntity, ContainerData caskDataIn) {
        super((MenuType)HHModMenuTypes.CASK.get(), windowId);
        int column;
        this.blockEntity = blockEntity;
        this.inventory = blockEntity.getInventory();
        this.caskData = caskDataIn;
        this.level = playerInventory.f_35978_.m_9236_();
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        int startX = 8;
        int startY = 18;
        int inputStartX = 39;
        int inputStartY = 20;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 2; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 2 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new CaskResultSlot(playerInventory.f_35978_, blockEntity, (IItemHandler)this.inventory, 4, 124, 29));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.m_38884_(caskDataIn);
    }

    private static CaskBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof CaskBlockEntity) {
            return (CaskBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean m_6875_(Player playerIn) {
        return CaskMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)HHModBlocks.CASK.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexMealDisplay = 4;
        int indexOutput = 4;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack slotStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            slotStackCopy = slotStack.m_41777_();
            if (index == indexOutput ? !this.m_38903_(slotStack, startPlayerInv, endPlayerInv, true) : (index > indexOutput ? !this.m_38903_(slotStack, 0, indexMealDisplay, false) : !this.m_38903_(slotStack, startPlayerInv, endPlayerInv, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == slotStackCopy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public int getCookProgressionScaled() {
        int currentAgeTime = this.caskData.m_6413_(0);
        int baseCookTime = this.caskData.m_6413_(1);
        if (baseCookTime == 0) {
            return 0;
        }
        int lightLevel = this.blockEntity.getCurrentLightLevel();
        float effectiveMultiplier = lightLevel <= 5 ? 0.5f : (lightLevel <= 10 ? 1.0f : 2.0f);
        int effectiveCookTime = Math.max(1, (int)((float)baseCookTime * effectiveMultiplier));
        return currentAgeTime * 24 / effectiveCookTime;
    }

    public float getProgression() {
        return this.caskData.m_6413_(0);
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.m_36466_(this.inventory.getStackInSlot(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 4; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super RecipeWrapper> recipe) {
        return recipe.m_5818_((Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.level);
    }

    public int m_6636_() {
        return 4;
    }

    public int m_6635_() {
        return 2;
    }

    public int m_6656_() {
        return 2;
    }

    public int m_6653_() {
        return 5;
    }

    public RecipeBookType m_5867_() {
        return HearthAndHarvest.RECIPE_TYPE_AGING;
    }

    public boolean m_142157_(int slot) {
        return slot < this.m_6635_() * this.m_6656_();
    }
}

