/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.block.entity.container;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class WineRackSlotHelper {
    public static int getSlotFromHit(BlockState state, BlockHitResult hit) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        Vec3 local = hit.m_82450_().m_82492_((double)hit.m_82425_().m_123341_(), (double)hit.m_82425_().m_123342_(), (double)hit.m_82425_().m_123343_());
        local = switch (facing) {
            case Direction.NORTH -> local;
            case Direction.SOUTH -> new Vec3(1.0 - local.f_82479_, local.f_82480_, 1.0 - local.f_82481_);
            case Direction.EAST -> new Vec3(local.f_82481_, local.f_82480_, 1.0 - local.f_82479_);
            case Direction.WEST -> new Vec3(1.0 - local.f_82481_, local.f_82480_, local.f_82479_);
            default -> local;
        };
        int col = WineRackSlotHelper.getSlotCoord(local.f_82479_);
        int row = WineRackSlotHelper.getSlotCoord(1.0 - local.f_82480_);
        if (col < 0 || row < 0) {
            return -1;
        }
        if (facing == Direction.NORTH || facing == Direction.SOUTH || facing == Direction.EAST || facing == Direction.WEST) {
            if (col == 0) {
                col = 2;
            } else if (col == 2) {
                col = 0;
            }
        }
        return row * 3 + col;
    }

    private static int getSlotCoord(double coord) {
        int pixel = (int)(coord * 16.0);
        if (pixel < 1 || pixel > 14) {
            return -1;
        }
        int index = (pixel - 1) / 5;
        int offset = (pixel - 1) % 5;
        return offset < 4 ? index : -1;
    }
}

