/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.entity.goal;

import alabaster.hearthandharvest.common.registry.HHModEffects;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class TemptingEffectGoal
extends Goal {
    private final Mob mob;
    private LivingEntity attractSource;
    private final double approachSpeed;
    private final double closeSpeed;
    private final double baseRadius;

    public TemptingEffectGoal(Mob mob, double approachSpeed, double closeSpeed, double baseRadius) {
        this.mob = mob;
        this.approachSpeed = approachSpeed;
        this.closeSpeed = closeSpeed;
        this.baseRadius = baseRadius;
    }

    private double getEffectiveRadius() {
        if (this.attractSource != null && this.attractSource.m_21023_((MobEffect)HHModEffects.TEMPTING.get())) {
            int amplifier = this.attractSource.m_21124_((MobEffect)HHModEffects.TEMPTING.get()).m_19564_();
            return this.baseRadius * (1.0 + 0.5 * (double)amplifier);
        }
        return this.baseRadius;
    }

    public boolean m_8036_() {
        if (!(this.mob instanceof Animal)) {
            return false;
        }
        List candidates = this.mob.m_9236_().m_6443_(LivingEntity.class, this.mob.m_20191_().m_82400_(this.baseRadius), entity -> entity != this.mob && entity.m_21023_((MobEffect)HHModEffects.TEMPTING.get()));
        if (!candidates.isEmpty()) {
            this.attractSource = candidates.stream().min(Comparator.comparingDouble(arg_0 -> ((Mob)this.mob).m_20280_(arg_0))).orElse(null);
            return this.attractSource != null;
        }
        return false;
    }

    public boolean m_8045_() {
        double effectiveRadius = this.getEffectiveRadius();
        return this.attractSource != null && this.mob.m_20280_((Entity)this.attractSource) < effectiveRadius * effectiveRadius;
    }

    public void m_8056_() {
        this.moveTowardSource();
    }

    public void m_8037_() {
        if (this.attractSource != null) {
            this.moveTowardSource();
        }
    }

    private void moveTowardSource() {
        double targetZ;
        double targetX;
        if (this.attractSource instanceof Player) {
            int offsetZ;
            int offsetX;
            double dx = this.mob.m_20185_() - this.attractSource.m_20185_();
            double dz = this.mob.m_20189_() - this.attractSource.m_20189_();
            if (Math.abs(dx) < 1.0E-6 && Math.abs(dz) < 1.0E-6) {
                offsetX = 1;
                offsetZ = 0;
            } else {
                offsetX = (int)Math.signum(dx);
                offsetZ = (int)Math.signum(dz);
            }
            targetX = this.attractSource.m_20185_() + (double)offsetX;
            targetZ = this.attractSource.m_20189_() + (double)offsetZ;
        } else {
            double effectiveRadius = this.getEffectiveRadius();
            Vec3 direction = new Vec3(this.attractSource.m_20185_() - this.mob.m_20185_(), 0.0, this.attractSource.m_20189_() - this.mob.m_20189_()).m_82541_();
            targetX = this.mob.m_20185_() + direction.f_82479_ * effectiveRadius;
            targetZ = this.mob.m_20189_() + direction.f_82481_ * effectiveRadius;
        }
        PathNavigation navigation = this.mob.m_21573_();
        navigation.m_26519_(targetX, this.mob.m_20186_(), targetZ, this.mob.m_20280_((Entity)this.attractSource) < 16.0 ? this.closeSpeed : this.approachSpeed);
    }

    public void m_8041_() {
        this.attractSource = null;
    }
}

