/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.item;

import alabaster.hearthandharvest.common.registry.HHModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class MarshmallowStickItem
extends Item {
    private static final int MAX_COOK_TIME = 10;

    public MarshmallowStickItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        Player player;
        if (!level.f_46443_ && entity instanceof Player && MarshmallowStickItem.isPlayerNearHeatSource(player = (Player)entity, level) && level.m_46467_() % 20L == 0L) {
            CompoundTag tag = stack.m_41784_();
            int cookTime = tag.m_128451_("CookTime");
            if (cookTime < 10) {
                tag.m_128405_("CookTime", ++cookTime);
            }
            if (stack.m_41720_() == HHModItems.MARSHMALLOW_STICK.get() && cookTime >= 5) {
                this.replaceItemInHand(player, stack, this.createCookedItem((Item)HHModItems.ROASTED_MARSHMALLOW_STICK.get(), cookTime));
            } else if (stack.m_41720_() == HHModItems.ROASTED_MARSHMALLOW_STICK.get() && cookTime >= 10) {
                this.replaceItemInHand(player, stack, this.createCookedItem((Item)HHModItems.CHARRED_MARSHMALLOW_STICK.get(), cookTime));
            }
        }
    }

    private ItemStack createCookedItem(Item cookedItem, int cookTime) {
        ItemStack newStack = new ItemStack((ItemLike)cookedItem);
        newStack.m_41784_().m_128405_("CookTime", cookTime);
        return newStack;
    }

    private void replaceItemInHand(Player player, ItemStack oldStack, ItemStack newStack) {
        if (player.m_21205_() == oldStack) {
            player.m_21008_(InteractionHand.MAIN_HAND, newStack);
        } else if (player.m_21206_() == oldStack) {
            player.m_21008_(InteractionHand.OFF_HAND, newStack);
        }
    }

    private static boolean isPlayerNearHeatSource(Player player, Level level) {
        if (player.m_6060_()) {
            return true;
        }
        BlockPos pos = player.m_20183_();
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
            if (!level.m_8055_(nearbyPos).m_60713_(Blocks.f_50683_)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.m_41720_() == HHModItems.MARSHMALLOW_STICK.get()) {
            tooltipComponents.add((Component)Component.m_237113_((String)"Hold near a campfire to cook").m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_41720_() == HHModItems.ROASTED_MARSHMALLOW_STICK.get()) {
            tooltipComponents.add((Component)Component.m_237113_((String)"Perfectly roasted!").m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_41720_() == HHModItems.CHARRED_MARSHMALLOW_STICK.get()) {
            tooltipComponents.add((Component)Component.m_237113_((String)"Oh, it's burnt...").m_130940_(ChatFormatting.DARK_GRAY));
        }
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
    }
}

