/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WateringCanItem
extends Item {
    private static final int MAX_WATER = 16;
    private static final int MAX_BONEMEAL = 16;
    private static final String WATER_NBT = "WaterLevel";
    private static final String BONEMEAL_NBT = "BoneMealLevel";

    public WateringCanItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getWaterCharge(stack) > 0 || this.getBoneMealCharge(stack) > 0;
    }

    public int m_142159_(ItemStack stack) {
        return 276466;
    }

    public int m_142158_(ItemStack stack) {
        int totalCharge = this.getWaterCharge(stack) + this.getBoneMealCharge(stack);
        return Math.round(13.0f * ((float)totalCharge / 32.0f));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack canStack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            int currentBonemeal;
            ItemStack offhandStack = player.m_21206_();
            if (offhandStack.m_150930_(Items.f_42499_) && (currentBonemeal = this.getBoneMealCharge(canStack)) < 16) {
                if (!level.m_5776_()) {
                    offhandStack.m_41774_(1);
                    this.setBoneMealCharge(canStack, currentBonemeal + 1);
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_144074_, SoundSource.PLAYERS, 0.8f, 1.0f);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        double x = player.m_20185_();
                        double y = player.m_20186_() + 0.8;
                        double z = player.m_20189_();
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 10, 0.5, 0.4, 0.5, 0.05);
                    }
                }
                return InteractionResultHolder.m_19092_((Object)canStack, (boolean)level.m_5776_());
            }
            BlockHitResult hitResult = WateringCanItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = hitResult.m_82425_();
                BlockState targetState = level.m_8055_(pos);
                if (targetState.m_60734_() == Blocks.f_49990_ && this.getWaterCharge(canStack) < 16) {
                    this.setWaterCharge(canStack, 16);
                    if (!level.m_5776_()) {
                        level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19092_((Object)canStack, (boolean)level.m_5776_());
                }
                if (this.isExtinguishable(targetState) && this.getWaterCharge(canStack) > 0) {
                    if (targetState.m_60734_() == Blocks.f_50083_) {
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    } else {
                        level.m_7731_(pos, (BlockState)targetState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    if (level.m_5776_()) {
                        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    this.consumeWater(canStack);
                    return InteractionResultHolder.m_19092_((Object)canStack, (boolean)level.m_5776_());
                }
                if (targetState.m_60734_() instanceof BonemealableBlock) {
                    boolean applied;
                    int water = this.getWaterCharge(canStack);
                    int bonemeal = this.getBoneMealCharge(canStack);
                    if (water > 0 && bonemeal > 0 && (applied = this.applyBonemeal(level, pos, targetState, player))) {
                        this.consumeBoth(canStack);
                        level.m_5594_(null, pos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.25, 0.3, 0.25, 0.05);
                        }
                        return InteractionResultHolder.m_19092_((Object)canStack, (boolean)level.m_5776_());
                    }
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)canStack);
    }

    private boolean isExtinguishable(BlockState state) {
        if (state.m_61138_((Property)CampfireBlock.f_51227_) && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            return true;
        }
        return state.m_60734_() == Blocks.f_50083_;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack canStack = context.m_43722_();
        BlockState state = level.m_8055_(pos);
        if (!level.m_5776_() && player != null && state.m_60734_() instanceof BonemealableBlock) {
            boolean applied;
            int water = this.getWaterCharge(canStack);
            int bonemeal = this.getBoneMealCharge(canStack);
            if (water > 0 && bonemeal > 0 && (applied = this.applyBonemeal(level, pos, state, player))) {
                this.consumeBoth(canStack);
                level.m_5594_(null, pos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.25, 0.3, 0.25, 0.05);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void consumeWater(ItemStack stack) {
        int water = this.getWaterCharge(stack);
        this.setWaterCharge(stack, water - 1);
    }

    private void consumeBoth(ItemStack stack) {
        int water = this.getWaterCharge(stack);
        int boneMeal = this.getBoneMealCharge(stack);
        this.setWaterCharge(stack, water - 1);
        this.setBoneMealCharge(stack, boneMeal - 1);
    }

    private int getWaterCharge(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(WATER_NBT);
    }

    private void setWaterCharge(ItemStack stack, int value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(WATER_NBT, value);
    }

    private int getBoneMealCharge(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(BONEMEAL_NBT);
    }

    private void setBoneMealCharge(ItemStack stack, int value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(BONEMEAL_NBT, value);
    }

    private boolean applyBonemeal(Level level, BlockPos centerPos, BlockState state, @Nullable Player player) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean appliedAny = false;
        int radius = 1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BonemealableBlock growable;
                mutablePos.m_122178_(centerPos.m_123341_() + dx, centerPos.m_123342_(), centerPos.m_123343_() + dz);
                BlockState targetState = level.m_8055_((BlockPos)mutablePos);
                Block block = targetState.m_60734_();
                if (!(block instanceof BonemealableBlock) || !(growable = (BonemealableBlock)block).m_7370_((LevelReader)level, (BlockPos)mutablePos, targetState, false) || !growable.m_214167_((Level)serverLevel, level.m_213780_(), (BlockPos)mutablePos, targetState)) continue;
                growable.m_214148_(serverLevel, level.m_213780_(), (BlockPos)mutablePos, targetState);
                serverLevel.m_46796_(2005, (BlockPos)mutablePos, 0);
                appliedAny = true;
            }
        }
        return appliedAny;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int waterLevel = this.getWaterCharge(stack);
        int boneMealLevel = this.getBoneMealCharge(stack);
        tooltip.add((Component)Component.m_237113_((String)("Water Level: " + waterLevel + " / 16")).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.m_237113_((String)("Bone Meal Level: " + boneMealLevel + " / 16")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

