/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.common.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class WineBottleItem
extends Item {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;
    private final Supplier<Fluid> fluid;

    public WineBottleItem(Supplier<Fluid> fluid, Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        super(properties);
        this.fluid = fluid;
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.hasCustomTooltip = hasCustomTooltip;
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        FoodProperties food = stack.getFoodProperties((LivingEntity)player);
        if (food != null) {
            if (player.m_36391_(food != null && food.m_38747_())) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11772_;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.f_46443_) {
            this.affectConsumer(stack, level, consumer);
        }
        ItemStack containerStack = stack.getCraftingRemainingItem();
        if (stack.m_41614_()) {
            super.m_5922_(stack, level, consumer);
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        if (stack.m_41619_()) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!((Player)consumer).m_150110_().f_35937_ && !player.m_150109_().m_36054_(containerStack)) {
                player.m_36176_(containerStack, false);
            }
        }
        return stack;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + String.valueOf((Object)this)), (Object[])new Object[0]);
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip, (float)1.0f);
            }
        }
    }
}

