/*
 * Decompiled with CFR 0.152.
 */
package alabaster.hearthandharvest.data;

import alabaster.hearthandharvest.HearthAndHarvest;
import alabaster.hearthandharvest.common.registry.HHModItems;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";

    public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "hearthandharvest", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = BuiltInRegistries.f_257033_.m_123024_().filter(i -> "hearthandharvest".equals(BuiltInRegistries.f_257033_.m_7981_(i).m_135827_())).collect(Collectors.toSet());
        this.blockBasedModel((Item)HHModItems.TREE_TAPPER.get(), "");
        items.remove(HHModItems.TREE_TAPPER.get());
        this.blockBasedModel((Item)HHModItems.CASK.get(), "");
        items.remove(HHModItems.CASK.get());
        this.blockBasedModel((Item)HHModItems.JUG.get(), "");
        items.remove(HHModItems.JUG.get());
        this.blockBasedModel(HHModItems.COUNTER.get(), "");
        items.remove(HHModItems.COUNTER.get());
        this.blockBasedModel(HHModItems.DRAWER.get(), "");
        items.remove(HHModItems.DRAWER.get());
        this.blockBasedModel(HHModItems.BASIN.get(), "");
        items.remove(HHModItems.BASIN.get());
        this.blockBasedModel(HHModItems.OAK_HALF_CABINET.get(), "");
        items.remove(HHModItems.OAK_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.BIRCH_HALF_CABINET.get(), "");
        items.remove(HHModItems.BIRCH_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.SPRUCE_HALF_CABINET.get(), "");
        items.remove(HHModItems.SPRUCE_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.JUNGLE_HALF_CABINET.get(), "");
        items.remove(HHModItems.JUNGLE_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.ACACIA_HALF_CABINET.get(), "");
        items.remove(HHModItems.ACACIA_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.DARK_OAK_HALF_CABINET.get(), "");
        items.remove(HHModItems.DARK_OAK_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.MANGROVE_HALF_CABINET.get(), "");
        items.remove(HHModItems.MANGROVE_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.CHERRY_HALF_CABINET.get(), "");
        items.remove(HHModItems.CHERRY_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.BAMBOO_HALF_CABINET.get(), "");
        items.remove(HHModItems.BAMBOO_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.CRIMSON_HALF_CABINET.get(), "");
        items.remove(HHModItems.CRIMSON_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.WARPED_HALF_CABINET.get(), "");
        items.remove(HHModItems.WARPED_HALF_CABINET.get());
        this.blockBasedModel(HHModItems.OAK_WINE_RACK.get(), "");
        items.remove(HHModItems.OAK_WINE_RACK.get());
        this.blockBasedModel(HHModItems.BIRCH_WINE_RACK.get(), "");
        items.remove(HHModItems.BIRCH_WINE_RACK.get());
        this.blockBasedModel(HHModItems.SPRUCE_WINE_RACK.get(), "");
        items.remove(HHModItems.SPRUCE_WINE_RACK.get());
        this.blockBasedModel(HHModItems.JUNGLE_WINE_RACK.get(), "");
        items.remove(HHModItems.JUNGLE_WINE_RACK.get());
        this.blockBasedModel(HHModItems.ACACIA_WINE_RACK.get(), "");
        items.remove(HHModItems.ACACIA_WINE_RACK.get());
        this.blockBasedModel(HHModItems.DARK_OAK_WINE_RACK.get(), "");
        items.remove(HHModItems.DARK_OAK_WINE_RACK.get());
        this.blockBasedModel(HHModItems.MANGROVE_WINE_RACK.get(), "");
        items.remove(HHModItems.MANGROVE_WINE_RACK.get());
        this.blockBasedModel(HHModItems.CHERRY_WINE_RACK.get(), "");
        items.remove(HHModItems.CHERRY_WINE_RACK.get());
        this.blockBasedModel(HHModItems.BAMBOO_WINE_RACK.get(), "");
        items.remove(HHModItems.BAMBOO_WINE_RACK.get());
        this.blockBasedModel(HHModItems.CRIMSON_WINE_RACK.get(), "");
        items.remove(HHModItems.CRIMSON_WINE_RACK.get());
        this.blockBasedModel(HHModItems.WARPED_WINE_RACK.get(), "");
        items.remove(HHModItems.WARPED_WINE_RACK.get());
        items.remove(HHModItems.MARSHMALLOW_STICK.get());
        items.remove(HHModItems.ROASTED_MARSHMALLOW_STICK.get());
        items.remove(HHModItems.CHARRED_MARSHMALLOW_STICK.get());
        items.remove(HHModItems.BLUEBERRY_WINE.get());
        items.remove(HHModItems.CHERRY_WINE.get());
        items.remove(HHModItems.RASPBERRY_WINE.get());
        items.remove(HHModItems.GREEN_GRAPE_WINE.get());
        items.remove(HHModItems.RED_GRAPE_WINE.get());
        items.remove(HHModItems.SWEET_BERRY_WINE.get());
        items.remove(HHModItems.MEAD.get());
        items.remove(HHModItems.WATERING_CAN.get());
        this.blockBasedModel((Item)HHModItems.EGG_CRATE.get(), "_bottom");
        items.remove(HHModItems.EGG_CRATE.get());
        this.blockBasedModel((Item)HHModItems.TURTLE_EGG_CRATE.get(), "_bottom");
        items.remove(HHModItems.TURTLE_EGG_CRATE.get());
        this.blockBasedModel((Item)HHModItems.MILK_CRATE.get(), "_bottom");
        items.remove(HHModItems.MILK_CRATE.get());
        this.blockBasedModel((Item)HHModItems.GOAT_MILK_CRATE.get(), "_bottom");
        items.remove(HHModItems.GOAT_MILK_CRATE.get());
        this.blockBasedModel((Item)HHModItems.BLUEBERRY_WINE_CRATE.get(), "_bottom");
        items.remove(HHModItems.BLUEBERRY_WINE_CRATE.get());
        this.blockBasedModel((Item)HHModItems.CHERRY_WINE_CRATE.get(), "_bottom");
        items.remove(HHModItems.CHERRY_WINE_CRATE.get());
        this.blockBasedModel((Item)HHModItems.RASPBERRY_WINE_CRATE.get(), "_bottom");
        items.remove(HHModItems.RASPBERRY_WINE_CRATE.get());
        this.blockBasedModel((Item)HHModItems.RED_GRAPE_WINE_CRATE.get(), "_bottom");
        items.remove(HHModItems.RED_GRAPE_WINE_CRATE.get());
        this.blockBasedModel((Item)HHModItems.GREEN_GRAPE_WINE_CRATE.get(), "_bottom");
        items.remove(HHModItems.GREEN_GRAPE_WINE_CRATE.get());
        this.blockBasedModel((Item)HHModItems.SWEET_BERRY_WINE_CRATE.get(), "_bottom");
        items.remove(HHModItems.SWEET_BERRY_WINE_CRATE.get());
        this.blockBasedModel((Item)HHModItems.MEAD_CRATE.get(), "_bottom");
        items.remove(HHModItems.MEAD_CRATE.get());
        this.blockBasedModel((Item)HHModItems.WATER_CRATE.get(), "_bottom");
        items.remove(HHModItems.WATER_CRATE.get());
        this.blockBasedModel((Item)HHModItems.HONEY_CRATE.get(), "_bottom");
        items.remove(HHModItems.HONEY_CRATE.get());
        this.blockBasedModel((Item)HHModItems.SYRUP_CRATE.get(), "_bottom");
        items.remove(HHModItems.SYRUP_CRATE.get());
        this.blockBasedModel((Item)HHModItems.BROWN_MUSHROOM_CRATE.get(), "_bottom");
        items.remove(HHModItems.BROWN_MUSHROOM_CRATE.get());
        this.blockBasedModel((Item)HHModItems.RED_MUSHROOM_CRATE.get(), "_bottom");
        items.remove(HHModItems.RED_MUSHROOM_CRATE.get());
        this.blockBasedModel((Item)HHModItems.CRIMSON_FUNGUS_CRATE.get(), "_bottom");
        items.remove(HHModItems.CRIMSON_FUNGUS_CRATE.get());
        this.blockBasedModel((Item)HHModItems.WARPED_FUNGUS_CRATE.get(), "_bottom");
        items.remove(HHModItems.WARPED_FUNGUS_CRATE.get());
        HashSet spriteBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)HHModItems.JAR.get(), (Item)HHModItems.BLUEBERRY_JAM.get(), (Item)HHModItems.CHERRY_JAM.get(), (Item)HHModItems.GRAPE_JAM.get(), (Item)HHModItems.RASPBERRY_JAM.get(), (Item)HHModItems.APPLE_JAM.get(), (Item)HHModItems.SWEET_BERRY_JAM.get(), (Item)HHModItems.GLOW_BERRY_JAM.get(), (Item)HHModItems.MELON_JAM.get(), (Item)HHModItems.PEANUT_BUTTER.get(), (Item)HHModItems.PICKLED_BEETROOTS.get(), (Item)HHModItems.PICKLED_CABBAGE.get(), (Item)HHModItems.PICKLED_CARROTS.get(), (Item)HHModItems.PICKLED_ONIONS.get(), (Item)HHModItems.PICKLED_POTATOES.get(), (Item)HHModItems.RASPBERRY.get(), (Item)HHModItems.BLUEBERRIES.get(), (Item)HHModItems.RED_GRAPES.get(), (Item)HHModItems.GREEN_GRAPES.get(), (Item)HHModItems.PEANUT.get(), (Item)HHModItems.COTTON_SEEDS.get(), (Item)HHModItems.RASPBERRY_PIE.get(), (Item)HHModItems.BLUEBERRY_PIE.get(), (Item)HHModItems.GRAPE_PIE.get(), (Item)HHModItems.PEANUT_BUTTER_PIE.get(), (Item)HHModItems.CHICKEN_POT_PIE.get(), (Item)HHModItems.UNRIPE_CHEDDAR_CHEESE_WHEEL.get(), (Item)HHModItems.CHEDDAR_CHEESE_WHEEL.get(), (Item)HHModItems.UNRIPE_GOAT_CHEESE_WHEEL.get(), (Item)HHModItems.GOAT_CHEESE_WHEEL.get(), (Item)HHModItems.CARROT_CAKE.get()});
        ItemModels.takeAll(items, spriteBlockItems.toArray(new Item[0])).forEach(item -> ((ItemModelBuilder)this.withExistingParent(this.itemName((Item)item), GENERATED)).texture("layer0", this.resourceItem(this.itemName((Item)item))));
        HashSet flatBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)HHModItems.WILD_RED_GRAPES.get(), (Item)HHModItems.WILD_GREEN_GRAPES.get(), (Item)HHModItems.WILD_COTTON.get(), (Item)HHModItems.WILD_PEANUTS.get()});
        ItemModels.takeAll(items, flatBlockItems.toArray(new Item[0])).forEach(item -> this.itemGeneratedModel((Item)item, this.resourceBlock(this.itemName((Item)item))));
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        HashSet handheldItems = Sets.newHashSet((Object[])new Item[]{(Item)HHModItems.FLINT_CLEAVER.get(), (Item)HHModItems.IRON_CLEAVER.get(), (Item)HHModItems.DIAMOND_CLEAVER.get(), (Item)HHModItems.GOLDEN_CLEAVER.get(), (Item)HHModItems.NETHERITE_CLEAVER.get()});
        ItemModels.takeAll(items, handheldItems.toArray(new Item[0])).forEach(item -> this.itemHandheldModel((Item)item, this.resourceItem(this.itemName((Item)item))));
        items.forEach(item -> this.itemGeneratedModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    public void itemHandheldModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", texture);
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("hearthandharvest", "block/" + path);
    }

    public ResourceLocation resourceItem(String path) {
        return new ResourceLocation("hearthandharvest", "item/" + path);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            HearthAndHarvest.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            HearthAndHarvest.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            HearthAndHarvest.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }
}

