/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time;

import java.util.Collection;
import net.lavabucket.hourglass.Hourglass;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.registry.TimeEffects;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.time.Time;
import net.lavabucket.hourglass.time.TimeContext;
import net.lavabucket.hourglass.time.effects.TimeEffect;
import net.lavabucket.hourglass.utils.MathUtils;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.TimePacketWrapper;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeService {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Time DAY_START = new Time(23500L);
    public static final Time NIGHT_START = new Time(12500L);
    private static final int OVERFLOW_THRESHOLD = 2147328000;
    public final ServerLevelWrapper level;
    public final SleepStatus sleepStatus;
    private double timeDecimalAccumulator = 0.0;

    public TimeService(ServerLevelWrapper level) {
        this.level = level;
        this.sleepStatus = new SleepStatus(() -> (Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get());
        this.level.setSleepStatus(this.sleepStatus);
    }

    public void tick() {
        if (!this.level.daylightRuleEnabled()) {
            return;
        }
        Time oldTime = this.getDayTime();
        Time deltaTime = this.tickTime();
        Time time = this.getDayTime();
        TimeContext context = new TimeContext(this, time, deltaTime);
        this.getActiveTimeEffects().forEach(effect -> effect.onTimeTick(context));
        boolean overrideSleep = (Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get();
        if (overrideSleep && !this.sleepStatus.allAwake() && Time.crossedMorning(oldTime, time)) {
            this.handleMorning();
        }
        this.preventTimeOverflow();
        this.broadcastTime();
        this.vanillaTimeCompensation();
    }

    private void handleMorning() {
        long time = ((ServerLevel)this.level.get()).m_46468_();
        ForgeEventFactory.onSleepFinished((ServerLevel)((ServerLevel)this.level.get()), (long)time, (long)time);
        this.sleepStatus.m_144001_();
        this.level.wakeUpAllPlayers();
        if (this.level.weatherRuleEnabled() && ((Boolean)HourglassConfig.SERVER_CONFIG.clearWeatherOnWake.get()).booleanValue()) {
            this.level.stopWeather();
        }
        LOGGER.debug(Hourglass.MARKER, "Sleep cycle complete on dimension: {}.", (Object)((ServerLevel)this.level.get()).m_46472_().m_135782_());
    }

    private void vanillaTimeCompensation() {
        ((ServerLevel)this.level.get()).m_8615_(((ServerLevel)this.level.get()).m_46468_() - 1L);
    }

    private void preventTimeOverflow() {
        long time = ((ServerLevel)this.level.get()).m_46468_();
        if (time > 2147328000L) {
            ((ServerLevel)this.level.get()).m_8615_(time - 2147328000L);
        }
    }

    private Time tickTime() {
        Time time = this.getDayTime();
        Time timeDelta = new Time(this.getTimeSpeed(time));
        timeDelta = this.correctForOvershoot(time, timeDelta);
        this.setDayTime(time.add(timeDelta));
        return timeDelta;
    }

    private Time correctForOvershoot(Time time, Time timeDelta) {
        Time nextTime = time.add(timeDelta);
        Time timeOfDay = time.timeOfDay();
        Time nextTimeOfDay = nextTime.timeOfDay();
        if (this.sleepStatus.allAwake()) {
            if (NIGHT_START.betweenMod(timeOfDay, nextTimeOfDay)) {
                double nextTimeSpeed = this.getTimeSpeed(nextTime);
                Time timeUntilBreakpoint = NIGHT_START.subtract(timeOfDay);
                double breakpointRatio = 1.0 - timeUntilBreakpoint.divide(timeDelta);
                return timeUntilBreakpoint.add(nextTimeSpeed * breakpointRatio);
            }
            if (DAY_START.betweenMod(timeOfDay, nextTimeOfDay)) {
                double nextTimeSpeed = this.getTimeSpeed(nextTime);
                Time timeUntilBreakpoint = DAY_START.subtract(timeOfDay);
                double breakpointRatio = 1.0 - timeUntilBreakpoint.divide(timeDelta);
                return timeUntilBreakpoint.add(nextTimeSpeed * breakpointRatio);
            }
        } else {
            Time timeUntilMorning = Time.DAY_LENGTH.subtract(timeOfDay);
            if (timeUntilMorning.compareTo(timeDelta) < 0) {
                double nextTimeSpeed = (Double)HourglassConfig.SERVER_CONFIG.daySpeed.get();
                double breakpointRatio = 1.0 - timeUntilMorning.divide(timeDelta);
                return timeUntilMorning.add(nextTimeSpeed * breakpointRatio);
            }
        }
        return timeDelta;
    }

    public double getTimeSpeed(Time time) {
        if (!((Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get()).booleanValue() || this.sleepStatus.allAwake()) {
            if (time.equals(DAY_START) || time.timeOfDay().betweenMod(DAY_START, NIGHT_START)) {
                return (Double)HourglassConfig.SERVER_CONFIG.daySpeed.get();
            }
            return (Double)HourglassConfig.SERVER_CONFIG.nightSpeed.get();
        }
        if (this.sleepStatus.allAsleep() && (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedAll.get() >= 0.0) {
            return (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedAll.get();
        }
        double sleepRatio = this.sleepStatus.ratio();
        double curve = (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedCurve.get();
        double speedRatio = MathUtils.normalizedTunableSigmoid(sleepRatio, curve);
        double sleepSpeedMin = (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedMin.get();
        double sleepSpeedMax = (Double)HourglassConfig.SERVER_CONFIG.sleepSpeedMax.get();
        double multiplier = MathUtils.lerp(speedRatio, sleepSpeedMin, sleepSpeedMax);
        return multiplier;
    }

    public Time getDayTime() {
        return new Time(((ServerLevel)this.level.get()).m_46468_(), this.timeDecimalAccumulator);
    }

    public Time setDayTime(Time time) {
        this.timeDecimalAccumulator = time.fractionalValue();
        ((ServerLevel)this.level.get()).m_8615_(time.longValue());
        return time;
    }

    public void broadcastTime() {
        TimePacketWrapper timePacket = TimePacketWrapper.create(this.level);
        ((ServerLevel)this.level.get()).m_7654_().m_6846_().m_11314_().stream().filter(player -> this.managesLevel(new ServerLevelWrapper((LevelAccessor)player.m_9236_()))).forEach(player -> player.f_8906_.m_9829_((Packet)timePacket.get()));
    }

    public boolean managesLevel(ServerLevelWrapper levelToCheck) {
        if (((ServerLevel)this.level.get()).equals(levelToCheck.get())) {
            return true;
        }
        return ((ServerLevel)this.level.get()).equals(((ServerLevel)this.level.get()).m_7654_().m_129783_()) && ServerLevelWrapper.isDerived((LevelAccessor)levelToCheck.get());
    }

    private Collection<TimeEffect> getActiveTimeEffects() {
        return TimeEffects.REGISTRY.get().getValues();
    }
}

