/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time.effects;

import com.google.common.primitives.Ints;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.time.TimeContext;
import net.lavabucket.hourglass.time.effects.AbstractTimeEffect;
import net.lavabucket.hourglass.time.effects.EffectCondition;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;

public class WeatherSleepEffect
extends AbstractTimeEffect {
    @Override
    public void onTimeTick(TimeContext context) {
        ServerLevelWrapper level = context.getLevel();
        EffectCondition condition = (EffectCondition)((Object)HourglassConfig.SERVER_CONFIG.weatherEffect.get());
        boolean allAwake = context.getTimeService().sleepStatus.allAwake();
        if (level.weatherCycleEnabled() && (condition == EffectCondition.ALWAYS || condition == EffectCondition.SLEEPING && !allAwake)) {
            this.progressWeather(context);
        }
    }

    private void progressWeather(TimeContext context) {
        ServerLevelWrapper level = context.getLevel();
        int clearWeatherTime = level.levelData.m_6537_();
        int thunderTime = level.levelData.m_6558_();
        int rainTime = level.levelData.m_6531_();
        int weatherSpeed = Ints.saturatedCast((long)(context.getTimeDelta().longValue() - 1L));
        if (clearWeatherTime <= 0) {
            if (thunderTime > 0) {
                thunderTime = Math.max(1, thunderTime - weatherSpeed);
                level.levelData.m_6398_(thunderTime);
            }
            if (rainTime > 0) {
                rainTime = Math.max(1, rainTime - weatherSpeed);
                level.levelData.m_6399_(rainTime);
            }
        }
    }
}

