/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.mixin;

import java.util.Optional;
import net.conczin.immersive_furniture.InteractionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract Optional<BlockPos> m_21257_();

    @Shadow
    public abstract boolean m_5803_();

    @Inject(method={"checkBedExists()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void immersiveFurniture$checkBedExists(CallbackInfoReturnable<Boolean> cir) {
        Optional<BlockPos> sleepingPos = this.m_21257_();
        if (sleepingPos.isPresent() && InteractionManager.isFurnitureBed(this.m_9236_(), sleepingPos.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setPosToBed(Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void immersiveFurniture$setPosToBed(BlockPos pos, CallbackInfo ci) {
        if (InteractionManager.isFurnitureBed(this.m_9236_(), pos)) {
            this.immersiveFurniture$MoveToBed();
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void immersiveFurniture$tick(CallbackInfo ci) {
        if (this.m_5803_()) {
            this.immersiveFurniture$MoveToBed();
        }
    }

    @Unique
    private void immersiveFurniture$MoveToBed() {
        InteractionManager.Interaction interaction = InteractionManager.INSTANCE.getInteraction((LivingEntity)this);
        if (interaction != null) {
            float rotation = interaction.offset().rotation();
            this.m_146922_(-rotation - 90.0f);
            this.m_5618_(-rotation - 90.0f);
            this.m_5616_(-rotation - 90.0f);
            this.m_6034_((float)interaction.pos().m_123341_() + interaction.offset().offset().x(), (float)interaction.pos().m_123342_() + interaction.offset().offset().y(), (float)interaction.pos().m_123343_() + interaction.offset().offset().z());
        }
    }
}

