/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_machinery.Items;
import immersive_machinery.Sounds;
import immersive_machinery.Utils;
import immersive_machinery.config.Config;
import immersive_machinery.entity.MachineEntity;
import immersive_machinery.entity.NavigatingMachine;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class RedstoneSheep
extends NavigatingMachine {
    private static final int INVENTORY_BUFFER_SPACE = 3;
    private static final int RESCAN_INTERVAL = 100;
    private BlockPos home;
    private BlockPos task;
    private int reloadingTicks;
    private int rescanningTicks;
    private int tasksHarvested;
    private Set<BlockPos> workingSet = new HashSet<BlockPos>();
    private Set<BlockPos> backlogSet = new HashSet<BlockPos>();

    public RedstoneSheep(EntityType<? extends MachineEntity> entityType, Level world) {
        super(entityType, world, false, false, 0);
        this.m_274367_(1.1f);
    }

    public boolean m_20068_() {
        return false;
    }

    protected SoundEvent getEngineSound() {
        return Sounds.REDSTONE_SHEEP.get();
    }

    protected float getEnginePitch() {
        float speed = (float)this.getSpeedVector().m_82553_();
        return Math.min(1.0f, 0.75f + speed * 10.0f);
    }

    protected float getEngineReactionSpeed() {
        return 10.0f;
    }

    @Override
    public void m_8119_() {
        double dz;
        double dx;
        super.m_8119_();
        if (this.home == null || this.home.m_123341_() == 0 && this.home.m_123342_() == 0 && this.home.m_123343_() == 0) {
            this.home = this.m_20183_();
        }
        if ((dx = this.m_20185_() - this.lastX) * dx + (dz = this.m_20189_() - this.lastZ) * dz > 1.0E-5) {
            this.m_146922_(Utils.lerpAngle(this.m_146908_(), (float)Math.toDegrees(Math.atan2(dz, dx)) + 90.0f, 10.0f));
        } else {
            this.m_146922_(Utils.lerpAngle(this.m_146908_(), (float)(Math.floor(this.m_146908_() / 90.0f + 0.5f) * 90.0), 5.0f));
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.isFuelLow() || this.isInventoryFull()) {
            this.reloadingTicks = 60;
        }
        --this.rescanningTicks;
        this.setEngineTarget(this.task != null ? 1.0f : 0.0f);
        if (this.reloadingTicks > 0) {
            if (this.moveTo(this.home) || !this.navigator.hasPath()) {
                --this.reloadingTicks;
            }
        } else if (this.task != null) {
            if (this.moveTo(this.task)) {
                VerifyState state = this.verify(this.task);
                if (state == VerifyState.VALID) {
                    this.work(this.task);
                }
                this.task = null;
            } else if (!this.navigator.hasPath()) {
                this.backlogSet.remove(this.task);
                this.task = null;
            }
        } else if (!this.workingSet.isEmpty()) {
            if ((this.m_9236_().m_46467_() + (long)this.m_19879_()) % 5L == 0L) {
                BlockPos closest = this.workingSet.stream().min(Comparator.comparingDouble(a -> a.m_203198_(this.m_20185_(), this.m_20186_(), this.m_20189_()))).get();
                VerifyState state = this.verify(closest);
                if (state == VerifyState.VALID) {
                    this.task = closest;
                    this.backlogSet.add(closest);
                    ++this.tasksHarvested;
                    this.rescanningTicks = 100;
                } else if (state == VerifyState.NOT_MATURE) {
                    this.backlogSet.add(closest);
                }
                this.workingSet.remove(closest);
            }
        } else if (!this.backlogSet.isEmpty()) {
            this.workingSet = this.backlogSet;
            this.backlogSet = new HashSet<BlockPos>();
            if (this.tasksHarvested == 0) {
                if (this.rescanningTicks <= 0) {
                    if (this.playerIsClose()) {
                        this.rescan();
                    }
                    this.rescanningTicks = 100;
                }
                this.reloadingTicks = 60;
            }
            this.tasksHarvested = 0;
        } else if (this.rescanningTicks <= 0) {
            this.rescan();
            this.rescanningTicks = 100;
        }
    }

    public boolean m_20160_() {
        return true;
    }

    private void rescan() {
        this.workingSet.clear();
        this.backlogSet.clear();
        int range = Config.getInstance().redstoneSheepMinHorizontalScanRange;
        LongOpenHashSet visited = new LongOpenHashSet();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(this.home);
        visited.add(this.home.m_121878_());
        while (!queue.isEmpty()) {
            BlockPos origin = (BlockPos)queue.poll();
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos = new BlockPos(x + origin.m_123341_(), origin.m_123342_(), z + origin.m_123343_());
                    if (visited.contains(pos.m_121878_())) continue;
                    visited.add(pos.m_121878_());
                    if (this.verify(pos) == VerifyState.INVALID) continue;
                    this.workingSet.add(pos);
                    queue.add(pos);
                }
            }
        }
    }

    private boolean playerIsClose() {
        return this.m_9236_().m_45930_((Entity)this, 32.0) != null;
    }

    private void work(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null).forEach(stack -> {
                ItemStack remainder = this.addItem((ItemStack)stack);
                if (!remainder.m_41619_()) {
                    Block.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)remainder);
                }
            });
            RedstoneSheep.getAgeProperty(state).ifPresentOrElse(age -> serverLevel.m_46597_(pos, (BlockState)state.m_61124_(age, (Comparable)Integer.valueOf(0))), () -> serverLevel.m_46961_(pos, false));
            this.consumeFuel(Config.getInstance().fuelTicksPerHarvest);
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10, 0.5, 0.0, 0.5, 1.0);
            serverLevel.m_5594_(null, pos, SoundEvents.f_12317_, SoundSource.BLOCKS, 1.0f, 1.2f);
        }
    }

    private VerifyState verify(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (RedstoneSheep.isCrop(block)) {
            if (RedstoneSheep.isMature(state)) {
                return VerifyState.VALID;
            }
            return VerifyState.NOT_MATURE;
        }
        return VerifyState.INVALID;
    }

    public static boolean isCrop(Block block) {
        String key = BuiltInRegistries.f_256975_.m_7981_((Object)block).toString();
        if (Config.getInstance().validCrops.containsKey(key)) {
            return Config.getInstance().validCrops.get(key);
        }
        return block instanceof CropBlock || block instanceof NetherWartBlock || block instanceof CocoaBlock || block instanceof PitcherCropBlock;
    }

    public static Optional<Property<Integer>> getAgeProperty(BlockState state) {
        for (Property property : state.m_61147_()) {
            if (!property.m_61708_().equals("age")) continue;
            try {
                return Optional.of(property);
            }
            catch (ClassCastException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static boolean isMature(BlockState state) {
        return RedstoneSheep.getAgeProperty(state).filter(p -> !Objects.equals(state.m_61143_(p), Collections.max(p.m_6908_()))).isEmpty();
    }

    private boolean isInventoryFull() {
        return this.countItems() > this.m_6643_() - 3;
    }

    private int countItems() {
        int i = 0;
        for (int j = 0; j < this.m_6643_(); ++j) {
            ItemStack itemStack = this.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            ++i;
        }
        return i;
    }

    public Item asItem() {
        return Items.REDSTONE_SHEEP.get();
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("HomeX", this.home.m_123341_());
        tag.m_128405_("HomeY", this.home.m_123342_());
        tag.m_128405_("HomeZ", this.home.m_123343_());
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.home = new BlockPos(tag.m_128451_("HomeX"), tag.m_128451_("HomeY"), tag.m_128451_("HomeZ"));
    }

    public void m_5757_(Container sender) {
        if (this.reloadingTicks > 0) {
            this.reloadingTicks = 60;
        }
    }

    public float getFuelConsumption() {
        return 0.0f;
    }

    static enum VerifyState {
        VALID,
        NOT_MATURE,
        INVALID;

    }
}

