/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetList
extends ContainerObjectSelectionList<Entry> {
    public static final int PADDING = 4;

    public WidgetList(Minecraft minecraft, int width, int height) {
        super(minecraft, width, height, 32, height - 32, 1);
        this.f_93394_ = false;
        this.f_93395_ = 4;
    }

    public void addWidgetGroup(List<AbstractWidget> widgets) {
        this.m_7085_((AbstractSelectionList.Entry)new Entry(widgets));
    }

    public void updateWidgetGroup(int index, List<AbstractWidget> widgets) {
        this.m_6702_().set(index, new Entry(widgets));
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    @Nullable
    public Entry getRealEntryAtPosition(double mouseX, double mouseY) {
        int halfRowWidth = this.m_5759_() / 2;
        int centerX = this.f_93393_ + this.f_93388_ / 2;
        int left = centerX - halfRowWidth;
        int right = centerX + halfRowWidth;
        int m = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        if (mouseX < (double)left || mouseX > (double)right || m < 0) {
            return null;
        }
        int height = 0;
        for (int idx = 0; idx < this.m_5773_(); ++idx) {
            Entry entry = (Entry)this.m_93500_(idx);
            if (m >= (height += entry.getHeight() + 4)) continue;
            return entry;
        }
        return null;
    }

    protected int m_5775_() {
        int itemsHeight = 0;
        for (int i = 0; i < this.m_5773_(); ++i) {
            itemsHeight += ((Entry)this.m_93500_(i)).getHeight() + 4;
        }
        return itemsHeight + this.f_93395_;
    }

    public int m_7610_(int index) {
        int itemsHeight = 0;
        for (int i = 0; i < index; ++i) {
            itemsHeight += ((Entry)this.m_93500_(i)).getHeight() + 4;
        }
        return this.f_93390_ - (int)this.m_93517_() + itemsHeight + this.f_93395_;
    }

    public int m_93485_(int index) {
        return this.m_7610_(index) + ((Entry)this.m_93500_(index)).getHeight();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        this.m_93410_(this.m_93517_() - scrollY * 10.0);
        return true;
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - 6;
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final List<AbstractWidget> children;
        private final List<Integer> childYs;

        private Entry(List<AbstractWidget> list) {
            this.children = ImmutableList.copyOf(list);
            this.childYs = this.children.stream().map(AbstractWidget::m_252907_).toList();
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            for (int i = 0; i < this.children.size(); ++i) {
                AbstractWidget widget = this.children.get(i);
                int relativeY = this.childYs.get(i);
                widget.m_253211_(top + relativeY);
                widget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public int getHeight() {
            int maxY = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                AbstractWidget widget = this.children.get(i);
                int relativeY = this.childYs.get(i);
                maxY = Math.max(relativeY + widget.m_93694_(), maxY);
            }
            return maxY;
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }
}

