/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature.util;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class DripstoneUtils {
    public static double getDripstoneHeight(double $$0, double $$1, double $$2, double $$3) {
        if ($$0 < $$3) {
            $$0 = $$3;
        }
        double $$4 = 0.384;
        double $$5 = $$0 / $$1 * 0.384;
        double $$6 = 0.75 * Math.pow($$5, 1.3333333333333333);
        double $$7 = Math.pow($$5, 0.6666666666666666);
        double $$8 = 0.3333333333333333 * Math.log($$5);
        double $$9 = $$2 * ($$6 - $$7 - $$8);
        $$9 = Math.max($$9, 0.0);
        return $$9 / 0.384 * $$1;
    }

    public static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel $$0, BlockPos $$1, int $$2) {
        if (DripstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)$$0, $$1)) {
            return false;
        }
        float $$3 = 6.0f;
        float $$4 = 6.0f / (float)$$2;
        for (float $$5 = 0.0f; $$5 < (float)Math.PI * 2; $$5 += $$4) {
            int $$7;
            int $$6 = (int)(Mth.m_14089_((float)$$5) * (float)$$2);
            if (!DripstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)$$0, $$1.m_7918_($$6, 0, $$7 = (int)(Mth.m_14031_((float)$$5) * (float)$$2)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrWater(LevelAccessor $$0, BlockPos $$1) {
        return $$0.m_7433_($$1, DripstoneUtils::isEmptyOrWater);
    }

    public static boolean isEmptyOrWaterOrLava(LevelAccessor $$0, BlockPos $$1) {
        return $$0.m_7433_($$1, DripstoneUtils::isEmptyOrWaterOrLava);
    }

    protected static void buildBaseToTipColumn(Direction $$0, int $$1, boolean $$2, Consumer<BlockState> $$3) {
        if ($$1 >= 3) {
            $$3.accept(DripstoneUtils.createPointedDripstone($$0, DripstoneThickness.BASE));
            for (int $$4 = 0; $$4 < $$1 - 3; ++$$4) {
                $$3.accept(DripstoneUtils.createPointedDripstone($$0, DripstoneThickness.MIDDLE));
            }
        }
        if ($$1 >= 2) {
            $$3.accept(DripstoneUtils.createPointedDripstone($$0, DripstoneThickness.FRUSTUM));
        }
        if ($$1 >= 1) {
            $$3.accept(DripstoneUtils.createPointedDripstone($$0, $$2 ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void growPointedDripstone(LevelAccessor level, HolderSet<Block> replaceable, BlockPos pos, Direction direction, int $$3, boolean $$4) {
        if (DripstoneUtils.isReplaceable(level.m_8055_(pos.m_121945_(direction.m_122424_())), replaceable)) {
            BlockPos.MutableBlockPos $$5 = pos.m_122032_();
            DripstoneUtils.buildBaseToTipColumn(direction, $$3, $$4, $$3x -> {
                if ($$3x.m_60713_(Blocks.f_152588_)) {
                    $$3x = (BlockState)$$3x.m_61124_((Property)PointedDripstoneBlock.f_154011_, (Comparable)Boolean.valueOf(level.m_46801_((BlockPos)$$5)));
                }
                level.m_7731_((BlockPos)$$5, $$3x, 2);
                $$5.m_122173_(direction);
            });
        }
    }

    protected static boolean placeDripstoneBlockIfPossible(LevelAccessor level, BlockStateProvider stateProvider, RandomSource random, HolderSet<Block> replaceable, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_204341_(replaceable)) {
            level.m_7731_(pos, stateProvider.m_213972_(random, pos), 2);
            return true;
        }
        return false;
    }

    private static BlockState createPointedDripstone(Direction direction, DripstoneThickness thickness) {
        return (BlockState)((BlockState)Blocks.f_152588_.m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)direction)).m_61124_((Property)PointedDripstoneBlock.f_154010_, (Comparable)thickness);
    }

    public static boolean isReplaceableOrLava(BlockState state, HolderSet<Block> replaceable) {
        return DripstoneUtils.isReplaceable(state, replaceable) || state.m_60713_(Blocks.f_49991_);
    }

    public static boolean isReplaceable(BlockState state, HolderSet<Block> replaceable) {
        return state.m_204341_(replaceable);
    }

    public static boolean isEmptyOrWater(BlockState $$0x) {
        return $$0x.m_60795_() || $$0x.m_60713_(Blocks.f_49990_);
    }

    public static boolean isNeitherEmptyNorWater(BlockState $$0) {
        return !$$0.m_60795_() && !$$0.m_60713_(Blocks.f_49990_);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState $$0x) {
        return $$0x.m_60795_() || $$0x.m_60713_(Blocks.f_49990_) || $$0x.m_60713_(Blocks.f_49991_);
    }
}

