/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.PriorityBasedModifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.TrueModifierPredicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public interface Modifier {
    public static final Codec<Modifier> CODEC = ExtraCodecs.m_184415_(() -> {
        Registry modifierRegistry = (Registry)BuiltInRegistries.f_257047_.m_7745_(LithostitchedRegistryKeys.MODIFIER_TYPE.m_135782_());
        if (modifierRegistry == null) {
            throw new NullPointerException("Worldgen modifier registry does not exist yet!");
        }
        return modifierRegistry.m_194605_();
    }).dispatch(Modifier::codec, Function.identity());

    public static <P extends Modifier> Products.P1<RecordCodecBuilder.Mu<P>, ModifierPredicate> addModifierFields(RecordCodecBuilder.Instance<P> codec) {
        return codec.group((App)ModifierPredicate.CODEC.fieldOf("predicate").orElse((Object)TrueModifierPredicate.INSTANCE).forGetter(Modifier::getPredicate));
    }

    public ModifierPredicate getPredicate();

    public ModifierPhase getPhase();

    default public void applyModifier(RegistryAccess registryAccess) {
        this.applyModifier();
    }

    public void applyModifier();

    public Codec<? extends Modifier> codec();

    public static void applyModifiers(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.m_206579_();
        HolderLookup.RegistryLookup modifiers = registries.m_255025_(LithostitchedRegistryKeys.WORLDGEN_MODIFIER);
        for (ModifierPhase phase : ModifierPhase.values()) {
            if (phase == ModifierPhase.NONE) continue;
            List<Holder.Reference<Modifier>> phaseModifiers = modifiers.m_214062_().filter(m -> ((Modifier)m.m_203334_()).getPhase() == phase).toList();
            Modifier.applyPhaseModifiers((RegistryAccess)registries, phaseModifiers);
        }
    }

    private static void applyPhaseModifiers(RegistryAccess registries, List<Holder.Reference<Modifier>> phaseModifiers) {
        ArrayList<Holder.Reference<PriorityBasedModifier>> priorityBasedModifiers = new ArrayList<Holder.Reference<PriorityBasedModifier>>();
        for (Holder.Reference<Modifier> reference : phaseModifiers) {
            if (reference.m_203334_() instanceof PriorityBasedModifier) {
                priorityBasedModifiers.add(reference);
                continue;
            }
            LithostitchedCommon.debug("Applying modifier with id: {}", reference.m_205785_().m_135782_());
            ((Modifier)reference.m_203334_()).applyModifier(registries);
        }
        for (Holder.Reference<Modifier> reference : Modifier.sortByPriority(priorityBasedModifiers)) {
            LithostitchedCommon.debug("Applying modifier with id: {}", reference.m_205785_().m_135782_());
            ((PriorityBasedModifier)reference.m_203334_()).applyModifier(registries);
        }
    }

    public static List<Holder.Reference<PriorityBasedModifier>> sortByPriority(List<Holder.Reference<PriorityBasedModifier>> modifiers) {
        return modifiers.stream().sorted(Comparator.comparingInt(reference -> ((PriorityBasedModifier)reference.m_203334_()).getPriority())).toList();
    }

    public static enum ModifierPhase implements StringRepresentable
    {
        NONE("none"),
        BEFORE_ALL("before_all"),
        REPLACE("replace"),
        ADD("add"),
        REMOVE("remove"),
        MODIFY("modify"),
        AFTER_ALL("after_all");

        private final String name;

        private ModifierPhase(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

