/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.NoiseRouterTarget;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.PriorityBasedModifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.modifier.util.DensityFunctionWrapper;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public record WrapNoiseRouterModifier(ModifierPredicate predicate, int priority, ResourceKey<Level> dimension, NoiseRouterTarget target, Holder<DensityFunction> wrapperFunction) implements Modifier
{
    public static final Codec<WrapNoiseRouterModifier> CODEC = RecordCodecBuilder.create(instance -> Modifier.addModifierFields(instance).and(instance.group((App)PriorityBasedModifier.PRIORITY_CODEC.forGetter(WrapNoiseRouterModifier::priority), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("dimension").forGetter(WrapNoiseRouterModifier::dimension), (App)NoiseRouterTarget.CODEC.fieldOf("target").forGetter(WrapNoiseRouterModifier::target), (App)DensityFunction.f_208217_.fieldOf("wrapper_function").forGetter(WrapNoiseRouterModifier::wrapperFunction))).apply((Applicative)instance, WrapNoiseRouterModifier::new));

    @Override
    public ModifierPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.NONE;
    }

    @Override
    public void applyModifier() {
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }

    public static DensityFunction modifyDensityFunction(NoiseRouterTarget target, DensityFunction wrapped, List<WrapNoiseRouterModifier> modifiers) {
        List<DensityFunction> orderedFunctions = modifiers.stream().filter(modifier -> modifier.target == target).sorted(Comparator.comparingInt(WrapNoiseRouterModifier::priority)).map(modifier -> (DensityFunction)modifier.wrapperFunction().m_203334_()).toList();
        if (orderedFunctions.isEmpty()) {
            return wrapped;
        }
        DensityFunction mergedFunction = wrapped;
        for (DensityFunction function : orderedFunctions) {
            mergedFunction = DensityFunctionWrapper.wrap(mergedFunction, function);
        }
        return mergedFunction;
    }

    public static enum Target implements StringRepresentable
    {
        BARRIER("barrier"),
        FLUID_LEVEL_FLOODEDNESS("fluid_level_floodedness"),
        FLUID_LEVEL_SPREAD("fluid_level_spread"),
        LAVA("lava"),
        TEMPERATURE("temperature"),
        VEGETATION("vegetation"),
        CONTINENTS("continents"),
        EROSION("erosion"),
        DEPTH("depth"),
        RIDGES("ridges"),
        INITIAL_DENSITY("initial_density_without_jaggedness"),
        FINAL_DENSITY("final_density"),
        VEIN_TOGGLE("vein_toggle"),
        VEIN_RIDGED("vein_ridged"),
        VEIN_GAP("vein_gap");

        public static final Codec<Target> CODEC;
        private final String name;

        private Target(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Target::values);
        }
    }
}

