/*
 * Decompiled with CFR 0.152.
 */
package com.mcwholidays.kikoz.objects.christmas;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Garland
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    private static final VoxelShape SIDE_S = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_E = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_W = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)12.0, (double)4.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_E = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_S = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_W = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape CORNER_N = Shapes.m_83110_((VoxelShape)SIDE_N, (VoxelShape)SIDE_E);
    protected static final VoxelShape CORNER_E = Shapes.m_83110_((VoxelShape)SIDE_E, (VoxelShape)SIDE_S);
    protected static final VoxelShape CORNER_S = Shapes.m_83110_((VoxelShape)SIDE_S, (VoxelShape)SIDE_W);
    protected static final VoxelShape CORNER_W = Shapes.m_83110_((VoxelShape)SIDE_W, (VoxelShape)SIDE_N);

    public Garland(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122434_().m_122479_() ? (BlockState)stateIn.m_61124_(SHAPE, (Comparable)Garland.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos)) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case WEST: {
                switch ((StairsShape)state.m_61143_(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_W;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_E;
                    }
                    case OUTER_LEFT: {
                        return OUTER_N;
                    }
                    case INNER_LEFT: {
                        return CORNER_S;
                    }
                }
                return CORNER_W;
            }
            case EAST: {
                switch ((StairsShape)state.m_61143_(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_E;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_W;
                    }
                    case OUTER_LEFT: {
                        return OUTER_S;
                    }
                    case INNER_LEFT: {
                        return CORNER_N;
                    }
                }
                return CORNER_E;
            }
            case SOUTH: {
                switch ((StairsShape)state.m_61143_(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_S;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_N;
                    }
                    case OUTER_LEFT: {
                        return OUTER_W;
                    }
                    case INNER_LEFT: {
                        return CORNER_E;
                    }
                }
                return CORNER_S;
            }
            case NORTH: {
                switch ((StairsShape)state.m_61143_(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_N;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_S;
                    }
                    case OUTER_LEFT: {
                        return OUTER_E;
                    }
                    case INNER_LEFT: {
                        return CORNER_W;
                    }
                }
                return CORNER_N;
            }
        }
        return null;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction horizontalDirection = context.m_8125_();
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)horizontalDirection);
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)Garland.getShapeProperty(blockstate, (BlockGetter)context.m_43725_(), blockpos));
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState blockstate = worldIn.m_8055_(pos.m_121945_(direction));
        if (Garland.isBlockStairs(blockstate) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != direction.m_122434_()) {
            return direction1 == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (Garland.isBlockStairs(blockstate1) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != direction.m_122434_()) {
            return direction2 == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.m_60734_() instanceof Garland;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)this.getMirroredShape(stairsshape));
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)this.getMirroredShape(stairsshape));
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    private StairsShape getMirroredShape(StairsShape shape) {
        switch (shape) {
            case INNER_LEFT: {
                return StairsShape.INNER_RIGHT;
            }
            case INNER_RIGHT: {
                return StairsShape.INNER_LEFT;
            }
            case OUTER_LEFT: {
                return StairsShape.OUTER_RIGHT;
            }
            case OUTER_RIGHT: {
                return StairsShape.OUTER_LEFT;
            }
        }
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE});
    }
}

