/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwbyg;

import fr.addonslib.api.data.ModType;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.registry.McwRegistry;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.mcwbyg.Mapping;
import fr.samlegamer.mcwbyg.Recipes;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="mcwbyg")
public class McwByg
extends McwMod {
    public static final String MODID = "mcwbyg";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> WOOD = List.of("aspen", "baobab", "blue_enchanted", "cika", "cypress", "ebony", "fir", "green_enchanted", "holly", "ironwood", "jacaranda", "mahogany", "maple", "palm", "pine", "rainbow_eucalyptus", "redwood", "sakura", "skyris", "white_mangrove", "willow", "witch_hazel", "zelkova", "florus");
    public static final List<String> STONE = List.of("dacite_bricks", "red_rock_bricks", "pink_sandstone", "white_sandstone", "blue_sandstone", "purple_sandstone", "black_sandstone", "windswept_sandstone");
    public static final List<String> LEAVES = List.of("aspen", "baobab", "blue_enchanted", "cika", "cypress", "ebony", "fir", "green_enchanted", "holly", "ironwood", "jacaranda", "mahogany", "maple", "palm", "pine", "rainbow_eucalyptus", "redwood", "skyris", "white_mangrove", "willow", "witch_hazel", "zelkova", "blue_spruce", "orange_spruce", "red_spruce", "yellow_spruce", "brown_birch", "orange_birch", "red_birch", "yellow_birch", "brown_oak", "orange_oak", "red_oak", "white_sakura", "yellow_sakura", "red_maple", "araucaria", "blooming_witch_hazel", "flowering_indigo_jacaranda", "flowering_ironwood", "flowering_jacaranda", "flowering_orchard", "flowering_palo_verde", "flowering_skyris", "flowering_yucca");
    private static final DeferredRegister<Block> block = Registration.blocks((String)"mcwbyg");
    private static final DeferredRegister<Item> item = Registration.items((String)"mcwbyg");
    public static final DeferredRegister<CreativeModeTab> ct = Registration.creativeModeTab((String)"mcwbyg");
    public static final RegistryObject<CreativeModeTab> MCWBYG_TAB = ct.register("tab", () -> CreativeModeTab.builder().m_257737_(McwByg::getIcon).m_257941_((Component)Component.m_237115_((String)"mcwbyg.tab")).m_257652_());

    public McwByg(FMLJavaModLoadingContext context) {
        super(context);
        List<String> leavesClassic = List.of("aspen", "baobab", "blue_enchanted", "cika", "cypress", "ebony", "fir", "green_enchanted", "holly", "ironwood", "jacaranda", "mahogany", "maple", "palm", "pine", "rainbow_eucalyptus", "redwood", "skyris", "white_mangrove", "willow", "witch_hazel", "zelkova", "blue_spruce", "orange_spruce", "red_spruce", "yellow_spruce", "brown_birch", "orange_birch", "red_birch", "yellow_birch", "brown_oak", "orange_oak", "red_oak", "red_maple", "araucaria", "blooming_witch_hazel", "flowering_indigo_jacaranda", "flowering_ironwood", "flowering_jacaranda", "flowering_orchard", "flowering_palo_verde", "flowering_skyris", "flowering_yucca");
        Map mapLeaveSoundCherry = McwRegistry.makeDefaultFromList(List.of("white_sakura", "yellow_sakura"), (SoundType)SoundType.f_271239_);
        LOGGER.info("Macaw's Oh The Biomes We've Gone Loading...");
        Registration.init((FMLJavaModLoadingContext)context, block, item, ct);
        McwRegistry.setRegistriesWood(WOOD, block, item, (ModType[])Registration.getAllModTypeWood());
        McwRegistry.setRegistriesLeave(leavesClassic, block, item);
        McwRegistry.setRegistriesLeave((Map)mapLeaveSoundCherry, block, item);
        McwRegistry.setRegistriesStone(STONE, block, item, (ModType[])Registration.getAllModTypeStone());
        context.getModEventBus().addListener(this::clientSetup);
        context.getModEventBus().addListener(this::commonSetup);
        context.getModEventBus().addListener(this::dataSetup);
        context.getModEventBus().addListener(this::tabSetup);
        MinecraftForge.EVENT_BUS.register(Mapping.class);
        LOGGER.info("Macaw's Oh The Biomes We've Gone Is Charged !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOOD, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVES);
        APIRenderTypes.initAllStone((FMLClientSetupEvent)event, (String)MODID, STONE, (ModType[])Registration.getAllModTypeStone());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOOD);
            McwLootTables.addBlockHedges((String)MODID, LEAVES);
            McwLootTables.addBlockAllStone((String)MODID, STONE);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture registries = gatherDataEvent.getLookupProvider();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(packOutput, registries, MODID, existingFileHelper){

                protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider p_256380_) {
                    this.addAllMcwTagsWood(McwByg.MODID, WOOD, Registration.getAllModTypeWood());
                    this.addAllMcwTagsStone(McwByg.MODID, STONE, Registration.getAllModTypeStone());
                    this.addAllMcwTagsLeave(McwByg.MODID, LEAVES);
                }
            };
            generator.addProvider(true, (DataProvider)new Recipes(packOutput));
            generator.addProvider(true, (DataProvider)mcwBlockTags);
            generator.addProvider(true, (DataProvider)new McwItemTags(packOutput, registries, mcwBlockTags.m_274426_(), MODID, existingFileHelper){

                protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider p_256380_) {
                    this.addAllMcwTagsWood(McwByg.MODID, WOOD, Registration.getAllModTypeWood());
                    this.addAllMcwTagsStone(McwByg.MODID, STONE, Registration.getAllModTypeStone());
                    this.addAllMcwTagsLeave(McwByg.MODID, LEAVES);
                }
            });
        }
    }

    public void tabSetup(BuildCreativeModeTabContentsEvent event) {
        APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, WOOD, (CreativeModeTab)((CreativeModeTab)MCWBYG_TAB.get()), (ModType[])Registration.getAllModTypeWood());
        APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, LEAVES, (CreativeModeTab)((CreativeModeTab)MCWBYG_TAB.get()));
        APICreativeTab.initAllStone((BuildCreativeModeTabContentsEvent)event, (String)MODID, STONE, (CreativeModeTab)((CreativeModeTab)MCWBYG_TAB.get()), (ModType[])Registration.getAllModTypeStone());
    }

    private static ItemStack getIcon() {
        NewIconRandom.NewProperties prop = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)"aspen_roof"), Finder.findBlock((String)MODID, (String)"aspen_picket_fence"), Finder.findBlock((String)MODID, (String)"aspen_wardrobe"), Finder.findBlock((String)MODID, (String)"aspen_log_bridge_middle"), Finder.findBlock((String)MODID, (String)"aspen_plank_window2"), Finder.findBlock((String)MODID, (String)"aspen_paper_door"), Finder.findBlock((String)MODID, (String)"aspen_blossom_trapdoor"), Finder.findBlock((String)MODID, (String)"aspen_planks_path"), Finder.findBlock((String)MODID, (String)"aspen_bulk_stairs"));
        prop.addType(ModType.ROOFS).addType(ModType.FENCES).addType(ModType.BRIDGES).addType(ModType.FURNITURES).addType(ModType.STAIRS).addType(ModType.DOORS).addType(ModType.TRAPDOORS).addType(ModType.PATHS).addType(ModType.WINDOWS);
        return new ItemStack((ItemLike)prop.buildIcon(new ModType[]{ModType.ROOFS, ModType.FENCES, ModType.BRIDGES, ModType.FURNITURES, ModType.STAIRS, ModType.DOORS, ModType.TRAPDOORS, ModType.PATHS, ModType.WINDOWS}));
    }
}

