/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwquark;

import fr.addonslib.api.data.ModType;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.registry.McwRegistry;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.mcwquark.Recipes;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="mcwquark")
public class McwQuark
extends McwMod {
    public static final String MODID = "mcwquark";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> stone = List.of("soul_sandstone_bricks", "limestone_bricks", "jasper_bricks", "shale_bricks", "permafrost_bricks", "red_sandstone_bricks", "sandstone_bricks", "cobblestone_bricks", "mossy_cobblestone_bricks", "blackstone_bricks", "diorite_bricks", "granite_bricks", "andesite_bricks", "calcite_bricks", "dripstone_bricks", "tuff_bricks", "raw_iron_bricks", "raw_gold_bricks", "raw_copper_bricks");
    public static final List<String> leaves = List.of("blue_blossom", "lavender_blossom", "orange_blossom", "red_blossom", "yellow_blossom", "ancient");
    public static final List<String> wood = List.of("blossom", "azalea", "ancient");
    private static final DeferredRegister<Block> BLOCKS = Registration.blocks((String)"mcwquark");
    private static final DeferredRegister<Item> ITEMS = Registration.items((String)"mcwquark");
    private static final DeferredRegister<CreativeModeTab> CT = Registration.creativeModeTab((String)"mcwquark");
    public static final RegistryObject<CreativeModeTab> MCWQUARK_TAB = CT.register("tab", () -> CreativeModeTab.builder().m_257737_(McwQuark::getIcon).m_257941_((Component)Component.m_237115_((String)"mcwquark.tab")).m_257652_());

    public McwQuark(FMLJavaModLoadingContext javaModLoadingContext) {
        super(javaModLoadingContext);
        List<String> rockClassic = List.of("soul_sandstone_bricks", "limestone_bricks", "jasper_bricks", "shale_bricks", "permafrost_bricks", "red_sandstone_bricks", "sandstone_bricks", "cobblestone_bricks", "mossy_cobblestone_bricks", "blackstone_bricks", "diorite_bricks", "granite_bricks", "andesite_bricks", "raw_iron_bricks", "raw_gold_bricks", "raw_copper_bricks");
        LinkedHashMap<String, SoundType> rockSounds = new LinkedHashMap<String, SoundType>();
        rockSounds.put("calcite_bricks", SoundType.f_154660_);
        rockSounds.put("dripstone_bricks", SoundType.f_154661_);
        rockSounds.put("tuff_bricks", SoundType.f_154659_);
        LOGGER.info("Macaw's Quark Loading...");
        Registration.init((FMLJavaModLoadingContext)javaModLoadingContext, BLOCKS, ITEMS, CT);
        McwRegistry.setRegistriesWood(wood, BLOCKS, ITEMS, (ModType[])Registration.getAllModTypeWood());
        McwRegistry.setRegistriesLeave(leaves, BLOCKS, ITEMS);
        McwRegistry.setRegistriesStone(rockClassic, BLOCKS, ITEMS, (ModType[])Registration.getAllModTypeStone());
        McwRegistry.setRegistriesStone(rockSounds, BLOCKS, ITEMS, (ModType[])Registration.getAllModTypeStone());
        javaModLoadingContext.getModEventBus().addListener(this::clientSetup);
        javaModLoadingContext.getModEventBus().addListener(this::commonSetup);
        javaModLoadingContext.getModEventBus().addListener(this::dataSetup);
        javaModLoadingContext.getModEventBus().addListener(this::tabSetup);
        LOGGER.info("Macaw's Quark Is Charged !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, wood, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, leaves);
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, stone, (ModType[])Registration.getAllModTypeStone());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, wood);
            McwLootTables.addBlockHedges((String)MODID, leaves);
            McwLootTables.addBlockAllStone((String)MODID, stone);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = gatherDataEvent.getLookupProvider();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(output, lookupProvider, MODID, existingFileHelper){

                protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider provider) {
                    this.addAllMcwTagsWood(McwQuark.MODID, wood, Registration.getAllModTypeWood());
                    this.addAllMcwTagsLeave(McwQuark.MODID, leaves);
                    this.addAllMcwTagsStone(McwQuark.MODID, stone, Registration.getAllModTypeStone());
                }
            };
            generator.addProvider(true, (DataProvider)new Recipes(output));
            generator.addProvider(true, (DataProvider)mcwBlockTags);
            generator.addProvider(true, (DataProvider)new McwItemTags(output, lookupProvider, mcwBlockTags.m_274426_(), MODID, existingFileHelper){

                protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider provider) {
                    this.addAllMcwTagsWood(McwQuark.MODID, wood, Registration.getAllModTypeWood());
                    this.addAllMcwTagsLeave(McwQuark.MODID, leaves);
                    this.addAllMcwTagsStone(McwQuark.MODID, stone, Registration.getAllModTypeStone());
                }
            });
        }
    }

    public void tabSetup(BuildCreativeModeTabContentsEvent event) {
        APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()), (ModType[])Registration.getAllModTypeWood());
        APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, leaves, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
        APICreativeTab.initAllStone((BuildCreativeModeTabContentsEvent)event, (String)MODID, stone, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()), (ModType[])Registration.getAllModTypeStone());
    }

    @Nonnull
    private static ItemStack getIcon() {
        NewIconRandom.NewProperties propIcon = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)"limestone_bricks_roof"), Finder.findBlock((String)MODID, (String)"orange_blossom_hedge"), Finder.findBlock((String)MODID, (String)"blossom_bookshelf"), Finder.findBlock((String)MODID, (String)"marble_bricks_bridge"), Finder.findBlock((String)MODID, (String)"azalea_shutter"), Finder.findBlock((String)MODID, (String)"blossom_beach_door"), Finder.findBlock((String)MODID, (String)"azalea_paper_trapdoor"), Finder.findBlock((String)MODID, (String)"blossom_planks_path"), Finder.findBlock((String)MODID, (String)"ancient_balcony"));
        propIcon.addType(ModType.BRIDGES).addType(ModType.ROOFS).addType(ModType.FENCES).addType(ModType.FURNITURES).addType(ModType.STAIRS).addType(ModType.WINDOWS).addType(ModType.DOORS).addType(ModType.TRAPDOORS).addType(ModType.PATHS);
        Block icon = propIcon.buildIcon(new ModType[]{ModType.BRIDGES, ModType.ROOFS, ModType.FENCES, ModType.FURNITURES, ModType.STAIRS, ModType.WINDOWS, ModType.DOORS, ModType.TRAPDOORS, ModType.PATHS});
        return new ItemStack((ItemLike)icon);
    }
}

