/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import dev.lucaargolo.mekanismcovers.MekanismCovers;
import dev.lucaargolo.mekanismcovers.ModConfig;
import dev.lucaargolo.mekanismcovers.mixed.TileEntityTransmitterMixed;
import java.lang.reflect.Method;
import java.util.Optional;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.transmitter.BlockTransmitter;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="mekanismcovers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MekanismCoversClient {
    public static final boolean ADVANCED_COVER_RENDERING = !ModConfig.getInstance().isDisableAdvancedCoverRendering();
    public static final boolean SHADER_COVER_RENDERING = ModConfig.getInstance().isEnableShaderCompatibleRendering();
    private static boolean lastTransparency = false;

    @SubscribeEvent
    public static void registerCoverModel(ModelEvent.RegisterAdditional event) {
        event.register(MekanismCovers.COVER_MODEL);
    }

    @SubscribeEvent
    public static void blockColorsRegister(RegisterColorHandlersEvent.Block event) {
        Block[] transmitters = MekanismBlocks.BLOCKS.getAllBlocks().stream().map(IBlockProvider::getBlock).filter(block -> block instanceof BlockTransmitter).toList().toArray(new Block[0]);
        event.register((pState, pLevel, pPos, pTintIndex) -> {
            TileEntityTransmitterMixed transmitter;
            BlockState coverState;
            TileEntityTransmitter tile;
            if (pTintIndex == 1337 && pPos != null && (tile = (TileEntityTransmitter)WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)pLevel, (BlockPos)pPos)) instanceof TileEntityTransmitterMixed && (coverState = (transmitter = (TileEntityTransmitterMixed)tile).mekanism_covers$getCoverState()) != null) {
                return event.getBlockColors().m_92577_(coverState, pLevel, pPos, pTintIndex);
            }
            return 0xFFFFFF;
        }, transmitters);
    }

    public static void updateCoverTransparency() {
        boolean transparency = MekanismCoversClient.isCoverTransparent();
        if (transparency != lastTransparency) {
            Minecraft client = Minecraft.m_91087_();
            if (client.f_91074_ == null || client.f_91073_ == null) {
                return;
            }
            int viewDistance = (int)Math.ceil(client.f_91060_.m_173017_());
            ChunkPos.m_45596_((ChunkPos)client.f_91074_.m_146902_(), (int)viewDistance).forEach(chunkPos -> {
                LevelChunk chunk = client.f_91073_.m_7726_().m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
                if (chunk != null) {
                    for (int i = 0; i < chunk.m_151559_(); ++i) {
                        LevelChunkSection section = chunk.m_183278_(i);
                        if (!section.m_63002_(state -> state.m_60734_() instanceof BlockTransmitter)) continue;
                        client.f_91060_.m_109770_(chunkPos.f_45578_, chunk.m_151568_(i), chunkPos.f_45579_);
                    }
                }
            });
        }
        lastTransparency = transparency;
    }

    public static boolean isCoverTransparentFast() {
        return lastTransparency;
    }

    private static boolean isCoverTransparent() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemStack mainStack = player.m_21205_();
            ItemStack offStack = player.m_21206_();
            ItemStack[] stacks = new ItemStack[]{mainStack, offStack};
            boolean transparent = false;
            for (ItemStack stack : stacks) {
                BlockItem blockItem;
                Block block;
                if (stack.m_150930_((Item)MekanismItems.CONFIGURATOR.get())) {
                    ItemConfigurator.ConfiguratorMode mode = (ItemConfigurator.ConfiguratorMode)((ItemConfigurator)MekanismItems.CONFIGURATOR.get()).getMode(mainStack);
                    if (mode == ItemConfigurator.ConfiguratorMode.WRENCH) continue;
                    transparent = true;
                    break;
                }
                Item item = stack.m_41720_();
                if (!(item instanceof BlockItem) || !((block = (blockItem = (BlockItem)item).m_40614_()) instanceof BlockTransmitter)) continue;
                transparent = true;
                break;
            }
            return transparent;
        }
        return false;
    }

    @NotNull
    public static ModelData getModelData(BlockState state, BlockAndTintGetter level, BlockPos worldPosition) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state).getModelData(level, worldPosition, state, ModelData.EMPTY);
    }

    public static boolean hasShaderPack() {
        try {
            Class<?> irisClass = Thread.currentThread().getContextClassLoader().loadClass("net.irisshaders.iris.Iris");
            Method packMethod = irisClass.getDeclaredMethod("getCurrentPack", new Class[0]);
            Optional optional = (Optional)packMethod.invoke(null, new Object[0]);
            return optional.isPresent();
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

