/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.mojang.blaze3d.audio.SoundBuffer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import org.embeddedt.modernfix.ModernFix;
import org.jetbrains.annotations.NotNull;

public class DynamicSoundHelpers {
    private static final long SOUND_EVICTION_DELAY = TimeUnit.SECONDS.toNanos(30L);
    private static final boolean debugDynamicSoundLoading = Boolean.getBoolean("modernfix.debugDynamicSoundLoading");

    public static final class Cache
    extends AbstractMap<ResourceLocation, CompletableFuture<SoundBuffer>> {
        private final Object2ObjectLinkedOpenHashMap<ResourceLocation, Entry> store = new Object2ObjectLinkedOpenHashMap();

        public Cache(Map<ResourceLocation, CompletableFuture<SoundBuffer>> otherMap) {
            this.putAll(otherMap);
        }

        private void checkExpired() {
            Object2ObjectMap.Entry entry;
            long ts = System.nanoTime();
            ObjectBidirectionalIterator iter = this.store.object2ObjectEntrySet().fastIterator();
            while (iter.hasNext() && ((Entry)(entry = (Object2ObjectMap.Entry)iter.next()).getValue()).isExpired(ts)) {
                if (debugDynamicSoundLoading) {
                    ModernFix.LOGGER.warn("Evicted sound {} with duration {} ms", entry.getKey(), (Object)(((Entry)entry.getValue()).getDuration() / 1000000L));
                }
                ((Entry)entry.getValue()).discard();
                iter.remove();
            }
        }

        @Override
        public CompletableFuture<SoundBuffer> get(Object key) {
            if (key instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)key;
                Entry entry = (Entry)this.store.getAndMoveToLast((Object)rl);
                CompletableFuture<SoundBuffer> result = entry != null ? entry.getBuffer() : null;
                this.checkExpired();
                return result;
            }
            return null;
        }

        @Override
        public CompletableFuture<SoundBuffer> put(ResourceLocation key, CompletableFuture<SoundBuffer> value) {
            Entry previousEntry;
            Entry entry = new Entry(value);
            if (debugDynamicSoundLoading) {
                ModernFix.LOGGER.info("Loaded sound {}", (Object)key);
            }
            return (previousEntry = (Entry)this.store.putAndMoveToLast((Object)key, (Object)entry)) != null ? previousEntry.getBuffer() : null;
        }

        @Override
        @NotNull
        public Set<Map.Entry<ResourceLocation, CompletableFuture<SoundBuffer>>> entrySet() {
            return new EntrySet();
        }

        private static class Entry {
            private final CompletableFuture<SoundBuffer> buffer;
            private long lastAccessTime;

            private Entry(CompletableFuture<SoundBuffer> buffer) {
                this.buffer = buffer;
                this.lastAccessTime = System.nanoTime();
            }

            public CompletableFuture<SoundBuffer> getBuffer() {
                this.lastAccessTime = System.nanoTime();
                return this.buffer;
            }

            public long getDuration() {
                SoundBuffer buf = this.buffer.getNow(null);
                if (buf == null) {
                    return 0L;
                }
                return ((SoundBufAccess)buf).mfix$getDurationNanos();
            }

            public boolean isExpired(long currentTs) {
                long duration = this.getDuration();
                return duration > 0L && currentTs - this.lastAccessTime >= duration + SOUND_EVICTION_DELAY;
            }

            public void discard() {
                this.buffer.thenAccept(SoundBuffer::m_83801_);
            }

            public String toString() {
                return super.toString();
            }
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<ResourceLocation, CompletableFuture<SoundBuffer>>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<ResourceLocation, CompletableFuture<SoundBuffer>>> iterator() {
                final ObjectBidirectionalIterator storeIter = Cache.this.store.entrySet().iterator();
                return new Iterator<Map.Entry<ResourceLocation, CompletableFuture<SoundBuffer>>>(){

                    @Override
                    public boolean hasNext() {
                        return storeIter.hasNext();
                    }

                    @Override
                    public Map.Entry<ResourceLocation, CompletableFuture<SoundBuffer>> next() {
                        Map.Entry entry = (Map.Entry)storeIter.next();
                        return new AbstractMap.SimpleImmutableEntry<ResourceLocation, CompletableFuture<SoundBuffer>>((ResourceLocation)entry.getKey(), ((Entry)entry.getValue()).buffer);
                    }
                };
            }

            @Override
            public int size() {
                return Cache.this.store.size();
            }

            @Override
            public void clear() {
                Cache.this.store.clear();
            }
        }
    }

    public static interface SoundBufAccess {
        public long mfix$getDurationNanos();
    }
}

