/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block.entity;

import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.block.AtmosphericBellowsBlock;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.util.DecimalFormats;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.lang.LangNumberFormat;
import net.dragonegg.moreburners.compat.embers.EmbersCompat;
import net.dragonegg.moreburners.config.ClientConfig;
import net.dragonegg.moreburners.config.CommonConfig;
import net.dragonegg.moreburners.content.block.EmberBurnerBlock;
import net.dragonegg.moreburners.content.block.entity.BaseBurnerBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class EmberBurnerBlockEntity
extends BaseBurnerBlockEntity
implements IExtraDialInformation {
    public static final double MAX_CAPACITY = (Double)CommonConfig.EMBER_BURNER_MAX_CAPACITY.get();
    public static final double EMBER_COST = (Double)CommonConfig.EMBER_BURNER_EMBER_COST.get();
    public static final double MAX_HEAT = (Double)CommonConfig.EMBER_BURNER_MAX_HEAT.get();
    public static final double MAX_HEAT_1 = (Double)CommonConfig.EMBER_BURNER_MAX_HEAT_BELLOWS_1.get();
    public static final double MAX_HEAT_2 = (Double)CommonConfig.EMBER_BURNER_MAX_HEAT_BELLOWS_2.get();
    public static final double HEATING_RATE = (Double)CommonConfig.EMBER_BURNER_HEATING_RATE.get();
    public static final double COOLING_RATE = (Double)CommonConfig.EMBER_BURNER_COOLING_RATE.get();
    public static final double RATE_MULTIPLIER = (Double)CommonConfig.EMBER_BURNER_RATE_BELLOWS_MULTIPLIER.get();
    public static final List<? extends String> BLOCK_COVERED = (List)ClientConfig.EMBER_BURNER_BLOCK_COVERED.get();
    protected static Random random = new Random();
    public IEmberCapability capability = new DefaultEmberCapability(){

        public void onContentsChanged() {
            super.onContentsChanged();
            EmberBurnerBlockEntity.this.m_6596_();
        }
    };

    public EmberBurnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EmbersCompat.EMBER_BURNER_ENTITY.get(), pos, state);
        this.capability.setEmberCapacity(MAX_CAPACITY);
        this.heat = 0.0;
        this.max_heat = MAX_HEAT;
        this.ticksExisted = 0;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.capability.writeToNBT(nbt);
        return nbt;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        return !this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY ? this.capability.getCapability(cap, side) : super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        ++this.ticksExisted;
        if (level.f_46443_) {
            this.spawnParticles(this.getHeatLevelFromBlock());
        } else {
            double heatingRate = HEATING_RATE;
            double coolingRate = COOLING_RATE;
            if (this.isBellowsAdjacent()) {
                this.max_heat = MAX_HEAT_1;
                heatingRate *= RATE_MULTIPLIER;
                coolingRate *= RATE_MULTIPLIER;
            } else {
                this.max_heat = this.isBellowsOneBlockAway() ? MAX_HEAT_2 : MAX_HEAT;
            }
            super.tick(level, pos, state);
            double prevHeat = this.heat;
            if (this.ticksExisted % 20 == 0) {
                for (BlockPos burnerPos : this.getAdjacentEmberBurners()) {
                    double cap2;
                    EmberBurnerBlockEntity adjBurner = (EmberBurnerBlockEntity)this.f_58857_.m_7702_(burnerPos);
                    double cap1 = this.capability.getEmber();
                    double transmit = Math.abs(cap1 - (cap2 = adjBurner.capability.getEmber())) / 2.0;
                    if (transmit < 0.5) continue;
                    if (cap1 > cap2) {
                        this.capability.removeAmount(transmit, true);
                        adjBurner.capability.addAmount(transmit, true);
                        continue;
                    }
                    adjBurner.capability.removeAmount(transmit, true);
                    this.capability.addAmount(transmit, true);
                }
            }
            if (this.capability.getEmber() >= EMBER_COST) {
                this.capability.removeAmount(EMBER_COST, true);
            } else {
                this.canWork = false;
            }
            if (this.ticksExisted % 20 == 0) {
                this.heat = this.canWork ? (this.heat += heatingRate) : (this.heat -= coolingRate);
                this.canWork = true;
            }
            this.heat = Mth.m_14008_((double)this.heat, (double)0.0, (double)this.max_heat);
            if (this.heat != prevHeat) {
                this.m_6596_();
                this.updateBlockState();
            }
        }
    }

    public List<BlockPos> getAdjacentEmberBurners() {
        if (this.f_58857_ == null) {
            return null;
        }
        ArrayList<BlockPos> poss = new ArrayList<BlockPos>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.f_58858_.m_121945_(dir);
            if (!(this.f_58857_.m_8055_(pos).m_60734_() instanceof EmberBurnerBlock)) continue;
            poss.add(pos);
        }
        return poss;
    }

    public boolean isBellowsOneBlockAway() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos pos;
                BlockState state;
                if (Math.abs(x) + Math.abs(z) != 2 || !((state = this.f_58857_.m_8055_(pos = this.f_58858_.m_7918_(x, 0, z))).m_60734_() instanceof AtmosphericBellowsBlock)) continue;
                BlockPos facedPos = pos.m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
                if (!this.getAdjacentEmberBurners().contains(facedPos)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBellowsAdjacent() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.f_58858_.m_121945_(direction);
            BlockState state = this.f_58857_.m_8055_(pos);
            if (!(state.m_60734_() instanceof AtmosphericBellowsBlock) || state.m_61143_((Property)BlockStateProperties.f_61374_) != direction.m_122424_()) continue;
            return true;
        }
        return false;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel) {
        Block above;
        if (this.f_58857_ != null && !EmberBurnerBlockEntity.isCovered(above = this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60734_()) && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            Color color = new Color(255, 64, 16);
            int particleCount = (int)(1.0f + (float)Math.sqrt(this.heat));
            if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
                color = new Color(color.getBlue(), color.getGreen(), color.getRed());
            }
            GlowParticleOptions options = new GlowParticleOptions(new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), 2.0f);
            BlockPos pos = this.f_58858_;
            for (int i = 0; i < particleCount; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)options, (double)pos.m_123341_() + 0.2 + (double)random.nextFloat() * 0.6, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.2 + (double)random.nextFloat() * 0.6, (Math.random() * 2.0 - 1.0) * 0.2, 0.0, (Math.random() * 2.0 - 1.0) * 0.2);
            }
        }
    }

    public static boolean isCovered(Block block) {
        String pass;
        Iterator<? extends String> var1 = BLOCK_COVERED.iterator();
        String[] ids = block.m_7705_().split("\\.");
        String id = ids[1] + ":" + ids[2];
        do {
            if (var1.hasNext()) continue;
            return false;
        } while (!(pass = var1.next()).equals(id));
        return true;
    }

    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        if (dialType == "ember") {
            DecimalFormat heatFormat = DecimalFormats.getDecimalFormat((String)"embers.decimal_format.heat");
            information.add((Component)Component.m_237110_((String)"embers.tooltip.dial.heat", (Object[])new Object[]{heatFormat.format(this.heat), heatFormat.format(this.max_heat)}));
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237119_());
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").translate("burner.ember.title", new Object[0]).style(ChatFormatting.GRAY), 0);
        LangBuilder builder = Lang.builder((String)"moreburners").text(LangNumberFormat.format((double)EMBER_COST)).style(ChatFormatting.AQUA).space().add(Lang.builder((String)"moreburners").translate("burner.per_tick", new Object[0]).style(ChatFormatting.DARK_GRAY));
        this.forGoggles(tooltip, builder, 1);
        return added;
    }
}

