/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Rhino
extends NaturalistAnimal
implements NaturalistGeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> CHARGE_COOLDOWN_TICKS = SynchedEntityData.m_135353_(Rhino.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.m_135353_(Rhino.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int stunnedTick;
    private boolean canBePushed = true;
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.rhino.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.rhino.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.rhino.run");
    protected static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.sf_nba.rhino.attack");
    protected static final RawAnimation FOOT = RawAnimation.begin().thenPlay("animation.sf_nba.rhino.foot");
    protected static final RawAnimation STUNNED = RawAnimation.begin().thenLoop("animation.sf_nba.rhino.stunned");

    public Rhino(EntityType<? extends NaturalistAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22277_, 12.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new MMPathNavigatorGround((Mob)this, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RhinoMeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(2, (Goal)new RhinoPrepareChargeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RhinoChargeGoal(this, 2.5));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BabyHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new RhinoNearestAttackablePlayerTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, false, false, p_213619_0_ -> p_213619_0_.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42047_));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)NaturalistEntityTypes.RHINO.get().m_20615_((Level)serverLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE_COOLDOWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(HAS_TARGET, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("StunTick", this.stunnedTick);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.stunnedTick = compound.m_128451_("StunTick");
    }

    public void setChargeCooldownTicks(int ticks) {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN_TICKS, (Object)ticks);
    }

    public int getChargeCooldownTicks() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_COOLDOWN_TICKS);
    }

    public boolean hasChargeCooldown() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_COOLDOWN_TICKS) > 0;
    }

    public void resetChargeCooldownTicks() {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN_TICKS, (Object)50);
    }

    public void setHasTarget(boolean hasTarget) {
        this.f_19804_.m_135381_(HAS_TARGET, (Object)hasTarget);
    }

    public boolean hasTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_TARGET);
    }

    public int m_8085_() {
        return this.m_20142_() ? 1 : 50;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_6084_()) {
            return;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(this.m_6107_() ? 0.0 : 0.2);
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
        }
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double e = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double f = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, d, e, f, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.stunnedTick > 0;
    }

    protected void m_6731_(LivingEntity defender) {
        this.stunnedTick = 60;
        this.resetChargeCooldownTicks();
        this.m_21573_().m_26573_();
        this.m_5496_(SoundEvents.f_12362_, 1.0f, 1.0f);
        this.m_9236_().m_7605_((Entity)this, (byte)39);
        defender.m_7334_((Entity)this);
        defender.f_19864_ = true;
    }

    public void m_7822_(byte id) {
        if (id == 39) {
            this.stunnedTick = 60;
        }
        super.m_7822_(id);
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.5);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    private boolean isWithinYRange(LivingEntity target) {
        if (target == null) {
            return false;
        }
        return Math.abs(target.m_20186_() - this.m_20186_()) < 3.0;
    }

    public boolean m_6094_() {
        return this.canBePushed;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_6162_() ? NaturalistSoundEvents.RHINO_AMBIENT_BABY.get() : NaturalistSoundEvents.RHINO_AMBIENT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Rhino> PlayState predicate(AnimationState<E> event) {
        if (this.stunnedTick > 0) {
            event.getController().setAnimation(STUNNED);
            event.getController().setAnimationSpeed(1.0);
        } else if (event.isMoving()) {
            if (this.m_20142_()) {
                event.getController().setAnimation(RUN);
                event.getController().setAnimationSpeed(3.0);
            } else {
                event.getController().setAnimation(WALK);
                event.getController().setAnimationSpeed(1.0);
            }
        } else if (this.hasChargeCooldown() && this.hasTarget()) {
            event.getController().setAnimation(FOOT);
            event.getController().setAnimationSpeed(1.0);
        } else {
            event.getController().setAnimation(IDLE);
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    private void soundListener(SoundKeyframeEvent<Rhino> event) {
        Rhino rhino = (Rhino)event.getAnimatable();
        if (rhino.m_9236_().f_46443_ && event.getKeyframeData().getSound().equals("scrape")) {
            rhino.m_9236_().m_7785_(rhino.m_20185_(), rhino.m_20186_(), rhino.m_20189_(), NaturalistSoundEvents.RHINO_SCRAPE.get(), rhino.m_5720_(), 1.0f, rhino.m_6100_(), false);
        }
    }

    private <E extends Rhino> PlayState attackPredicate(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.setAnimation(ATTACK);
            event.getController().setAnimationSpeed((double)1.3f);
            event.getController().forceAnimationReset();
        }
        this.f_20911_ = false;
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{controller});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate)});
    }

    static class RhinoMeleeAttackGoal
    extends MeleeAttackGoal {
        public RhinoMeleeAttackGoal(PathfinderMob pathfinderMob, double speedModifier, boolean followEvenIfNotSeen) {
            super(pathfinderMob, speedModifier, followEvenIfNotSeen);
        }

        public boolean m_8036_() {
            LivingEntity target = this.f_25540_.m_5448_();
            if (target instanceof Player) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.f_25540_.f_20911_ = false;
        }
    }

    static class RhinoPrepareChargeGoal
    extends Goal {
        protected final Rhino rhino;

        public RhinoPrepareChargeGoal(Rhino rhino) {
            this.rhino = rhino;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.rhino.m_5448_();
            if (target == null || !target.m_6084_() || this.rhino.stunnedTick > 0 || !this.rhino.isWithinYRange(target)) {
                this.rhino.resetChargeCooldownTicks();
                return false;
            }
            return target instanceof Player && this.rhino.hasChargeCooldown();
        }

        public void m_8056_() {
            LivingEntity target = this.rhino.m_5448_();
            if (target == null) {
                return;
            }
            this.rhino.setHasTarget(true);
            this.rhino.resetChargeCooldownTicks();
            this.rhino.canBePushed = false;
        }

        public void m_8041_() {
            this.rhino.setHasTarget(false);
            this.rhino.canBePushed = true;
        }

        public void m_8037_() {
            LivingEntity target = this.rhino.m_5448_();
            if (target == null) {
                return;
            }
            this.rhino.m_21563_().m_148051_((Entity)target);
            this.rhino.setChargeCooldownTicks(Math.max(0, this.rhino.getChargeCooldownTicks() - 1));
        }
    }

    static class RhinoChargeGoal
    extends Goal {
        protected final Rhino mob;
        private final double speedModifier;
        @Nullable
        private Path path;
        private Vec3 chargeDirection;

        public RhinoChargeGoal(Rhino pathfinderMob, double speedModifier) {
            this.mob = pathfinderMob;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.chargeDirection = Vec3.f_82478_;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_() || this.mob.hasChargeCooldown() || this.mob.stunnedTick > 0) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
            return target instanceof Player && this.path != null;
        }

        public boolean m_8045_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_() || this.mob.hasChargeCooldown() || this.mob.stunnedTick > 0) {
                return false;
            }
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            BlockPos blockPosition = this.mob.m_20183_();
            BlockPos target = this.path.m_77406_();
            this.chargeDirection = new Vec3((double)(blockPosition.m_123341_() - target.m_123341_()), 0.0, (double)(blockPosition.m_123343_() - target.m_123343_())).m_82541_();
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            this.mob.resetChargeCooldownTicks();
            this.mob.m_21573_().m_26573_();
            this.mob.f_20911_ = false;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            this.mob.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.path.m_77406_()));
            if (this.mob.f_19862_ && this.mob.m_20096_()) {
                this.mob.m_6135_();
            }
            if (this.mob.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                AABB boundingBox = this.mob.m_20191_().m_82400_(0.2);
                for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)boundingBox.f_82288_), (int)Mth.m_14107_((double)boundingBox.f_82289_), (int)Mth.m_14107_((double)boundingBox.f_82290_), (int)Mth.m_14107_((double)boundingBox.f_82291_), (int)Mth.m_14107_((double)boundingBox.f_82292_), (int)Mth.m_14107_((double)boundingBox.f_82293_))) {
                    BlockState state = this.mob.m_9236_().m_8055_(pos);
                    if (!state.m_204336_(NaturalistTags.BlockTags.RHINO_CHARGE_BREAKABLE)) continue;
                    this.mob.m_9236_().m_46953_(pos, true, (Entity)this.mob);
                }
            }
            if (!this.mob.m_9236_().m_5776_()) {
                ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), 5, (double)(this.mob.m_20205_() / 4.0f), 0.0, (double)(this.mob.m_20205_() / 4.0f), 0.01);
            }
            if (this.mob.m_9236_().m_46467_() % 2L == 0L) {
                this.mob.m_5496_(SoundEvents.f_11963_, 0.5f, this.mob.m_6100_());
            }
            this.tryToHurt();
        }

        protected void tryToHurt() {
            LivingEntity livingEntity;
            List nearbyEntities = this.mob.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this.mob, this.mob.m_20191_());
            if (!nearbyEntities.isEmpty() && !((livingEntity = (LivingEntity)nearbyEntities.get(0)) instanceof Rhino)) {
                livingEntity.m_6469_(livingEntity.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
                float speed = Mth.m_14036_((float)(this.mob.m_6113_() * 1.65f), (float)0.2f, (float)3.0f);
                float shieldBlockModifier = livingEntity.m_21275_(livingEntity.m_269291_().m_269333_((LivingEntity)this.mob)) ? 0.5f : 1.0f;
                livingEntity.m_147240_((double)(shieldBlockModifier * speed) * 2.0, this.chargeDirection.m_7096_(), this.chargeDirection.m_7094_());
                double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(0.0, (double)0.4f * knockbackResistance, 0.0));
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                if (livingEntity.equals((Object)this.mob.m_5448_())) {
                    this.m_8041_();
                }
            }
        }
    }

    static class RhinoNearestAttackablePlayerTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        private final Rhino rhino;

        public RhinoNearestAttackablePlayerTargetGoal(Rhino mob) {
            super((Mob)mob, Player.class, 10, true, true, EntitySelector.f_20406_::test);
            this.rhino = mob;
        }

        public boolean m_8036_() {
            if (this.rhino.m_6162_()) {
                return false;
            }
            if (super.m_8036_()) {
                if (!this.rhino.isWithinYRange(this.f_26050_)) {
                    return false;
                }
                List nearbyEntities = this.rhino.m_9236_().m_45976_(Rhino.class, this.rhino.m_20191_().m_82377_(8.0, 4.0, 8.0));
                for (Rhino mob : nearbyEntities) {
                    if (!mob.m_6162_()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

