/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.chassis_core.client.animators.HandAnimator;
import com.nukateam.chassis_core.client.render.layers.LayerBase;
import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.foundation.item.ChassisEquipment;
import com.nukateam.chassis_core.common.util.helpers.PlayerUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HandEquipmentLayer<T extends HandAnimator>
extends LayerBase<T> {
    public HandEquipmentLayer(GeoRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, T hand, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!PlayerUtils.isLocalWearingChassis()) {
            return;
        }
        WearableChassis entity = PlayerUtils.getLocalPlayerChassis();
        poseStack.m_85836_();
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        for (ChassisPart part : entity.getEquipment()) {
            if (!entity.isEquipmentVisible(part)) continue;
            ItemStack stack = entity.getEquipment(part);
            ChassisEquipment item = entity.getEquipmentItem(part);
            if (item.getConfig() == null) {
                return;
            }
            ResourceLocation texture = item.getTexture(stack);
            if (texture == null) {
                return;
            }
            this.renderLayer(poseStack, hand, bakedModel, bufferSource, partialTick, packedLight, texture);
        }
        poseStack.m_85849_();
    }
}

