/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.render.utils;

import com.nukateam.chassis_core.common.config.EquipmentConfig;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.data.EntityModelData;

public class GeoUtils {
    @Nullable
    public static Collection<GeoBone> getEquipmentBones(String boneName, WearableChassis animatable) {
        ArrayList<GeoBone> result = new ArrayList<GeoBone>();
        Collection<EquipmentConfig> configs = animatable.getItemConfigs();
        for (EquipmentConfig config : configs) {
            Collection<String> boneNames = config.getArmorBone(boneName);
            for (String name : boneNames) {
                GeoBone armorBone = GeoUtils.getBone(config.getModel(), name);
                if (armorBone == null) continue;
                result.add(armorBone);
            }
        }
        return result;
    }

    public static void setHeadAnimation(CoreGeoBone head, AnimationState animationState) {
        if (head == null) {
            return;
        }
        EntityModelData data = (EntityModelData)animationState.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(data.headPitch() * ((float)Math.PI / 180));
        head.setRotY(data.netHeadYaw() * ((float)Math.PI / 180));
    }

    public static void setHeadAnimation(LivingEntity animatable, AnimationProcessor animationProcessor, AnimationState animationState) {
        CoreGeoBone head = animationProcessor.getBone("head");
        if (head == null) {
            return;
        }
        GeoUtils.setHeadAnimation(head, animationState);
    }

    public static BakedGeoModel getModel(ResourceLocation location) {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(location);
    }

    @Nullable
    public static GeoBone getBone(ResourceLocation resourceLocation, String name) {
        BakedGeoModel model = GeoUtils.getModel(resourceLocation);
        return model == null ? null : (GeoBone)model.getBone(name).orElse(null);
    }

    public static Vec3 getRot(CoreGeoBone bone) {
        return new Vec3((double)bone.getRotX(), (double)bone.getRotY(), (double)bone.getRotZ());
    }

    public static Vec3 getPos(CoreGeoBone bone) {
        return new Vec3((double)bone.getPosX(), (double)bone.getPosY(), (double)bone.getPosZ());
    }

    public static void setRot(CoreGeoBone bone, Vec3 pos) {
        bone.setRotX((float)pos.f_82479_);
        bone.setRotX((float)pos.f_82480_);
        bone.setRotX((float)pos.f_82481_);
    }

    public static void setPos(CoreGeoBone bone, Vec3 pos) {
        bone.setPosX((float)pos.f_82479_);
        bone.setPosY((float)pos.f_82480_);
        bone.setPosZ((float)pos.f_82481_);
    }

    @Nullable
    public static ResourceLocation getTextureForBone(GeoBone bone, WearableChassis animatable) {
        if (bone == null || animatable == null) {
            return null;
        }
        ResourceLocation texture = animatable.getTextureForBone(bone.getName());
        if (texture == null) {
            for (GeoBone parent = bone.getParent(); parent != null && texture == null; parent = parent.getParent()) {
                texture = animatable.getTextureForBone(parent.getName());
            }
        }
        return texture;
    }
}

