/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.config;

import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.data.json.EquipmentAttachment;
import com.nukateam.chassis_core.modules.config.annotation.Ignored;
import com.nukateam.chassis_core.modules.config.annotation.Optional;
import com.nukateam.chassis_core.modules.config.utils.NbtUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class EquipmentConfig
implements INBTSerializable<CompoundTag> {
    @Ignored
    private ChassisPart part;
    @Optional
    LinkedHashSet<ResourceLocation> chassis;
    @Optional
    public ResourceLocation parent;
    @Ignored
    public ResourceLocation model;
    @Ignored
    public HashMap<String, ResourceLocation> texture;
    @Optional
    public String[] hide = new String[0];
    @Ignored
    public EquipmentAttachment[] attachments = new EquipmentAttachment[0];
    @Optional
    public String[] mods = new String[0];

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("part", this.part.toString());
        tag.m_128365_("chassis", (Tag)NbtUtils.serializeSet(this.chassis));
        tag.m_128359_("model", this.model.toString());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("part", 8)) {
            this.part = ChassisPart.getType(tag.m_128461_("part"));
        }
        if (tag.m_128425_("chassis", 10)) {
            this.chassis = NbtUtils.deserializeRLSet(tag.m_128469_("chassis"));
        }
        if (tag.m_128425_("model", 8)) {
            this.model = ResourceLocation.m_135820_((String)tag.m_128461_("model"));
        }
    }

    public EquipmentConfig copy() {
        EquipmentConfig config = new EquipmentConfig();
        config.part = this.part;
        config.chassis = this.chassis;
        config.model = this.model;
        return config;
    }

    public static EquipmentConfig create(CompoundTag tag) {
        EquipmentConfig config = new EquipmentConfig();
        config.deserializeNBT(tag);
        return config;
    }

    public ChassisPart getPart() {
        return this.part;
    }

    public Set<ResourceLocation> getChassis() {
        return this.chassis;
    }

    public Collection<String> getAllVariants() {
        return this.texture.keySet();
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public ResourceLocation getTexture(String tag) {
        return this.texture.get(tag);
    }

    public ResourceLocation getParent() {
        return this.parent;
    }

    public HashMap<String, ResourceLocation> getTextures() {
        return this.texture;
    }

    public String[] getHide() {
        return this.hide;
    }

    public EquipmentAttachment[] getAttachments() {
        return this.attachments;
    }

    public String[] getMods() {
        return this.mods;
    }

    @Nullable
    public Collection<String> getArmorBone(String chassisBone) {
        ArrayList<String> result = new ArrayList<String>();
        for (EquipmentAttachment attachment : this.attachments) {
            if (!Objects.equals(attachment.frame, chassisBone)) continue;
            result.add(attachment.armor);
        }
        return result;
    }

    public static class Builder {
        private final EquipmentConfig config;

        private Builder() {
            this.config = new EquipmentConfig();
        }

        private Builder(EquipmentConfig projectile) {
            this.config = projectile.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EquipmentConfig projectile) {
            return new Builder(projectile);
        }

        public EquipmentConfig build() {
            return this.config.copy();
        }

        public Builder setPart(ChassisPart part) {
            this.config.part = part;
            return this;
        }
    }
}

