/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.foundation.entity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.chassis_core.client.render.utils.GeoUtils;
import com.nukateam.chassis_core.client.render.utils.ResourceHelper;
import com.nukateam.chassis_core.common.config.ChassisConfig;
import com.nukateam.chassis_core.common.config.EquipmentConfig;
import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.data.json.EquipmentAttachment;
import com.nukateam.chassis_core.common.events.ContainerChangedEvent;
import com.nukateam.chassis_core.common.foundation.container.menu.DynamicChassisMenu;
import com.nukateam.chassis_core.common.foundation.entity.EmptyLivingEntity;
import com.nukateam.chassis_core.common.foundation.item.ChassisArmor;
import com.nukateam.chassis_core.common.foundation.item.ChassisEquipment;
import com.nukateam.chassis_core.common.foundation.item.ItemStackUtils;
import com.nukateam.chassis_core.common.foundation.item.StackUtils;
import com.nukateam.chassis_core.common.network.PacketHandler;
import com.nukateam.chassis_core.common.network.managers.ConfigSupplier;
import com.nukateam.chassis_core.common.network.managers.Configs;
import com.nukateam.chassis_core.common.network.packet.S2CInventoryPacket;
import com.nukateam.chassis_core.common.util.helpers.ContainerUtils;
import com.nukateam.chassis_core.common.util.helpers.InventoryHelper;
import com.nukateam.chassis_core.common.util.helpers.timer.TickTimer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.GeoBone;

public class Chassis
extends EmptyLivingEntity
implements ContainerListener {
    protected HashMap<ChassisPart, Integer> partIdMap = new HashMap();
    protected final TickTimer timer = new TickTimer();
    protected final boolean isClientSide;
    protected final boolean isServerSide;
    private final Lazy<String> chassisId;
    public final HashMap<String, ArrayList<GeoBone>> attachmentForBone;
    public final HashMap<String, ResourceLocation> textureForBone;
    public Collection<String> bonesToHide;
    public SimpleContainer inventory;
    protected float totalDefense;
    protected float totalToughness;
    private int inventorySize;
    private ListTag serializedInventory;
    private Container previousContainer;
    private int tickTimer;
    private int tickTimer5;

    public Chassis(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.isClientSide = this.m_9236_().f_46443_;
        this.isServerSide = !this.m_9236_().f_46443_;
        this.chassisId = Lazy.of(() -> ResourceHelper.getResourceName(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_())));
        this.attachmentForBone = new HashMap();
        this.textureForBone = new HashMap();
        this.bonesToHide = new ArrayList<String>();
        this.inventorySize = 0;
        this.tickTimer = 10;
        this.tickTimer5 = 5;
        this.f_19811_ = true;
        this.initInventory();
        this.updateParams();
        this.loadSlots();
    }

    private void loadSlots() {
        int i = 0;
        for (ChassisPart part : this.getConfig().getParts()) {
            this.partIdMap.put(part, i++);
        }
        this.inventorySize = this.partIdMap.size();
    }

    public static ChassisEquipment getAsChassisEquipment(ItemStack itemStack) {
        return (ChassisEquipment)itemStack.m_41720_();
    }

    public static <T, R> Collection<R> returnCollection(Collection<T> collection, Function<T, R> function) {
        ArrayList<R> result = new ArrayList<R>();
        for (T item : collection) {
            R val = function.apply(item);
            if (val == null) continue;
            result.add(val);
        }
        return result;
    }

    public <S extends INBTSerializable<CompoundTag>> void setConfig(ConfigSupplier<S> sConfigSupplier) {
    }

    public ChassisConfig getConfig() {
        return Configs.CHASSIS_CONFIGS.get(this.m_6095_()).getConfig();
    }

    public float getTotalDefense() {
        return this.totalDefense;
    }

    public float getTotalToughness() {
        return this.totalToughness;
    }

    public Collection<String> getBonesToHide() {
        return this.bonesToHide;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public void damageArmor(DamageSource damageSource, float damage) {
        if (this.isServerSide) {
            if (!damageSource.m_276093_(DamageTypes.f_268671_)) {
                this.damageArmorItem(ChassisPart.HELMET, damageSource, damage);
                this.damageArmorItem(ChassisPart.BODY_ARMOR, damageSource, damage);
                this.damageArmorItem(ChassisPart.LEFT_ARM_ARMOR, damageSource, damage);
                this.damageArmorItem(ChassisPart.RIGHT_ARM_ARMOR, damageSource, damage);
            }
            this.damageArmorItem(ChassisPart.LEFT_LEG_ARMOR, damageSource, damage);
            this.damageArmorItem(ChassisPart.RIGHT_LEG_ARMOR, damageSource, damage);
        }
    }

    public void damageArmorItem(ChassisPart chassisPart, DamageSource damageSource, float damage) {
        ItemStack itemStack = this.getEquipment(chassisPart);
        if (itemStack.m_41720_() instanceof ChassisArmor) {
            ItemStackUtils.damageItem(itemStack, (int)damage);
            this.setEquipment(chassisPart, itemStack);
        }
    }

    public ArrayList<String> getMods() {
        ArrayList<String> res = new ArrayList<String>();
        for (EquipmentConfig config : this.getItemConfigs()) {
            res.addAll(List.of(config.mods));
        }
        return res;
    }

    public ArrayList<String> getVisibleMods() {
        ArrayList<String> res = new ArrayList<String>();
        for (ItemStack item : this.getVisibleEquipment()) {
            res.addAll(StackUtils.getAttachments(item));
        }
        return res;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Collection<GeoBone> getAttachmentForBone(String chassisBone) {
        ArrayList result = this.attachmentForBone.get(chassisBone);
        return result == null ? new ArrayList() : result;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureForBone(String bone) {
        return this.textureForBone.get(bone);
    }

    @Nullable
    public Integer getPartId(ChassisPart chassisPart) {
        return this.partIdMap.get(chassisPart);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isClientSide) {
            if (this.tickTimer == 0) {
                this.tickTimer = 10;
                this.updateBones();
            } else {
                --this.tickTimer;
            }
        } else {
            this.tickTimer5 = Math.max(this.tickTimer5 - 1, 0);
            if (this.tickTimer5 == 0) {
                this.syncDataWithClient();
                this.tickTimer5 = 50;
            }
        }
    }

    protected void m_21217_() {
        this.removeEffects();
    }

    public void removeEffects() {
        for (MobEffectInstance effectInstance : this.m_21220_()) {
            this.m_21195_(effectInstance.m_19544_());
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        this.saveInventory(compound);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.loadInventory(compound);
    }

    public void m_5757_(@NotNull Container container) {
        if (this.previousContainer == null || !ContainerUtils.isContainersEqual(this.previousContainer, container)) {
            this.containerReallyChanged(container);
            this.previousContainer = ContainerUtils.copyContainer(container);
        }
    }

    public String getModelId() {
        return (String)this.chassisId.get();
    }

    public void containerReallyChanged(Container container) {
        this.updateParams();
        this.serializedInventory = InventoryHelper.serializeInventory(this.inventory);
        this.syncDataWithClient();
        MinecraftForge.EVENT_BUS.post((Event)new ContainerChangedEvent((Entity)this));
    }

    public boolean isEquipmentVisible(ChassisPart chassisPart) {
        return !this.getEquipment(chassisPart).m_41619_() && this.hasArmor(chassisPart);
    }

    public boolean hasArmor(ChassisPart chassisPart) {
        return this.getArmorDurability(chassisPart) != 0;
    }

    public Collection<ChassisPart> getEquipment() {
        return this.partIdMap.keySet();
    }

    public Collection<ChassisPart> getPovEquipment() {
        return Collections.singleton(ChassisPart.RIGHT_ARM_ARMOR);
    }

    public boolean hasEquipment(ChassisPart part) {
        return !this.getEquipment(part).m_41619_();
    }

    public Collection<ItemStack> getVisibleEquipment() {
        return Chassis.returnCollection(this.getEquipment(), part -> this.isEquipmentVisible((ChassisPart)part) ? this.getEquipment((ChassisPart)part) : null);
    }

    public Collection<EquipmentConfig> getItemConfigs() {
        return Chassis.returnCollection(this.getVisibleEquipment(), equipment -> ((ChassisEquipment)equipment.m_41720_()).getConfig());
    }

    public ItemStack getEquipment(ChassisPart chassisPart) {
        Integer id = this.getPartId(chassisPart);
        if (id == null) {
            id = 0;
        }
        return this.inventory.m_8020_(id.intValue());
    }

    public void setEquipment(ChassisPart chassisPart, ItemStack itemStack) {
        this.inventory.m_6836_(this.getPartId(chassisPart).intValue(), itemStack);
    }

    public int getArmorDurability(ChassisPart chassisPart) {
        ItemStack itemStack = this.getEquipment(chassisPart);
        if (itemStack.m_41619_()) {
            return 0;
        }
        return itemStack.m_41776_() - itemStack.m_41773_();
    }

    public void setArmorData(ListTag nbtTags) {
        if (this.isClientSide) {
            InventoryHelper.deserializeInventory(this.inventory, nbtTags);
        }
    }

    public void setInventory(ListTag tags) {
        InventoryHelper.deserializeInventory(this.inventory, tags);
    }

    protected void initInventory() {
        SimpleContainer inventoryBuff = this.inventory;
        this.loadSlots();
        this.inventory = new SimpleContainer(this.inventorySize);
        if (inventoryBuff != null) {
            inventoryBuff.m_19181_((ContainerListener)this);
            int i = Math.min(inventoryBuff.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemStack = inventoryBuff.m_8020_(j);
                if (itemStack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemStack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.serializedInventory = InventoryHelper.serializeInventory(this.inventory);
        this.syncDataWithClient();
    }

    protected void syncDataWithClient() {
        if (this.isServerSide) {
            PacketHandler.getPlayChannel().sendToTrackingEntity(() -> this, (IMessage)new S2CInventoryPacket(this.m_19879_(), this.serializedInventory));
        }
    }

    protected void saveInventory(CompoundTag compound) {
        if (this.inventory == null) {
            return;
        }
        compound.m_128365_("Items", (Tag)InventoryHelper.serializeInventory(this.inventory));
    }

    protected void loadInventory(@NotNull CompoundTag compound) {
        ListTag nbtTags = compound.m_128437_("Items", 10);
        this.initInventory();
        InventoryHelper.deserializeInventory(this.inventory, nbtTags);
    }

    @Nullable
    protected MenuProvider getMenuProvider() {
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                return new DynamicChassisMenu(containerId, (Container)Chassis.this.inventory, playerInventory, Chassis.this);
            }

            public Component m_5446_() {
                return Chassis.this.m_5446_();
            }
        };
    }

    protected float getMinSpeed() {
        return 0.05f;
    }

    private void updateParams() {
        this.updateTotalArmor();
        this.updateSpeed();
        if (this.isClientSide) {
            this.updateBones();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateBones() {
        this.attachmentForBone.clear();
        this.bonesToHide.clear();
        this.textureForBone.clear();
        for (ItemStack stack : this.getVisibleEquipment()) {
            ChassisEquipment item = Chassis.getAsChassisEquipment(stack);
            EquipmentConfig config = item.getConfig();
            if (config == null) continue;
            Collections.addAll(this.bonesToHide, config.hide);
            for (EquipmentAttachment attachment : config.attachments) {
                GeoBone bone;
                if (Arrays.stream(config.mods).toList().contains(attachment.armor) && !StackUtils.hasAttachment(stack, attachment.armor) || (bone = GeoUtils.getBone(config.getModel(), attachment.armor)) == null) continue;
                String variant = StackUtils.getVariant(stack);
                this.textureForBone.put(attachment.armor, config.getTexture(variant));
                if (!this.attachmentForBone.containsKey(attachment.frame)) {
                    this.attachmentForBone.put(attachment.frame, com.nukateam.chassis_core.common.util.extensions.Collection.arrayListOf(bone));
                    continue;
                }
                this.attachmentForBone.get(attachment.frame).add(bone);
            }
        }
    }

    protected void updateSpeed() {
        this.m_7910_(this.getSpeedAttribute());
    }

    public void updateTotalArmor() {
        this.totalDefense = 0.0f;
        this.totalToughness = 0.0f;
        for (ChassisPart part : this.partIdMap.keySet()) {
            Item item = this.getEquipment(part).m_41720_();
            if (!(item instanceof ChassisArmor)) continue;
            ChassisArmor armorItem = (ChassisArmor)item;
            this.totalDefense += (float)armorItem.getMaterial().getDefenseForSlot(part);
            this.totalToughness += armorItem.getMaterial().getToughness();
        }
    }

    public float getSpeedAttribute() {
        return (float)this.m_21133_(Attributes.f_22279_);
    }
}

