/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.foundation.item;

import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.util.helpers.EntityHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ChassisItem<T extends WearableChassis>
extends Item {
    private final EntityType.EntityFactory<T> factory;
    private final RegistryObject<EntityType<T>> type;

    public ChassisItem(Item.Properties properties, RegistryObject<EntityType<T>> type, EntityType.EntityFactory<T> factory) {
        super(properties.m_41487_(1));
        this.factory = factory;
        this.type = type;
    }

    private static void summonSavedEntity(Entity savedEntity, UseOnContext context) {
        ItemStack stack = context.m_43722_();
        ChassisItem.moveEntityToClickedBlock(savedEntity, context);
        if (context.m_43725_().m_7967_(savedEntity)) {
            EntityHelper.clearItemTags(stack);
            context.m_43723_().m_150109_().m_36057_(stack);
        }
    }

    private static void moveEntityToClickedBlock(Entity savedEntity, UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        savedEntity.m_19890_((double)clickedPos.m_123341_() + 0.5, (double)(clickedPos.m_123342_() + 1), (double)clickedPos.m_123343_() + 0.5, 180.0f + context.m_8125_().m_122435_(), 0.0f);
    }

    public void m_7836_(ItemStack itemStack, @NotNull Level world, @NotNull Player player) {
        itemStack.m_41751_(new CompoundTag());
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43719_() != Direction.UP) {
            return InteractionResult.FAIL;
        }
        Entity savedEntity = EntityHelper.entityFromItem(context.m_43722_(), context.m_43725_());
        if (savedEntity != null) {
            ChassisItem.summonSavedEntity(savedEntity, context);
        } else {
            this.summonNewEntity(context);
        }
        return InteractionResult.SUCCESS;
    }

    private void summonNewEntity(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        WearableChassis entity = (WearableChassis)this.factory.m_20721_((EntityType)this.type.get(), world);
        ChassisItem.moveEntityToClickedBlock((Entity)entity, context);
        if (world.m_7967_((Entity)entity)) {
            stack.m_41774_(1);
        }
    }
}

