/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.network.managers;

import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.chassis_core.common.network.PacketHandler;
import com.nukateam.chassis_core.common.network.managers.NetworkChassisManager;
import com.nukateam.chassis_core.common.network.managers.NetworkEquipmentManager;
import com.nukateam.chassis_core.common.network.packet.S2CMessageUpdateChassisConfig;
import com.nukateam.chassis_core.common.network.packet.S2CMessageUpdateEquipmentConfig;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class DatapackHandler {
    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        NetworkChassisManager.stop();
        NetworkEquipmentManager.stop();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketHandler.getPlayChannel().sendToPlayer(() -> player2, (IMessage)new S2CMessageUpdateChassisConfig());
            PacketHandler.getPlayChannel().sendToPlayer(() -> player2, (IMessage)new S2CMessageUpdateEquipmentConfig());
        }
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkChassisManager.register(event);
        NetworkEquipmentManager.register(event);
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketHandler.getPlayChannel().sendToAll((IMessage)new S2CMessageUpdateChassisConfig());
            PacketHandler.getPlayChannel().sendToAll((IMessage)new S2CMessageUpdateEquipmentConfig());
        }
    }
}

