/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.util.helpers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.chassis_core.common.data.enums.ActionType;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.network.PacketSender;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerUtils {
    public static void addEffect(Player player, MobEffect effect, int amplifier) {
        player.m_7292_(new MobEffectInstance(effect, 9, amplifier, false, false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static LocalPlayer getLocalPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isLocalWearingChassis() {
        return PlayerUtils.isWearingChassis((Entity)PlayerUtils.getLocalPlayer());
    }

    public static boolean isWearingChassis(Entity entity) {
        return entity != null && entity.m_20202_() instanceof WearableChassis;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static WearableChassis getLocalPlayerChassis() {
        return PlayerUtils.getEntityChassis((Entity)PlayerUtils.getLocalPlayer());
    }

    @Nullable
    public static WearableChassis getEntityChassis(Entity entity) {
        if (entity.m_20202_() instanceof WearableChassis) {
            return (WearableChassis)entity.m_20202_();
        }
        return null;
    }

    public static void stopWearingArmor(Player player) {
        if (PlayerUtils.isWearingChassis((Entity)player)) {
            player.m_8127_();
            PacketSender.doServerAction(ActionType.DISMOUNT);
            player.m_6842_(false);
        }
    }

    public static void renderChassisHand(PoseStack poseStack, boolean isRight, HumanoidArm hand, int packedLight) {
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        int x = 0;
        if (hand == HumanoidArm.RIGHT) {
            x = isRight ? -155 : 5;
        } else if (hand == HumanoidArm.LEFT) {
            x = isRight ? 5 : -155;
        }
        poseStack.m_85837_((double)x / 10.0 / 16.0, -0.625, -0.875);
        PlayerUtils.renderChassisHand(hand, poseStack, null, packedLight);
    }

    public static void renderChassisHand(HumanoidArm arm, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        PlayerUtils.getLocalPlayerChassis().getHandRenderer().render(arm, poseStack, multiBufferSource, packedLight);
    }
}

