/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.renderers.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.ntgl.client.util.helpers.render.RenderUtils;
import com.nukateam.ntgl.common.foundation.entity.LaserProjectile;
import com.nukateam.ntgl.common.util.data.Rgba;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class LaserProjectileRenderer
extends EntityRenderer<LaserProjectile> {
    public static final float BEAM_ALPHA = 0.7f;
    public static ResourceLocation LASER_TEXTURE = new ResourceLocation("ntgl", "textures/fx/laser.png");
    private static final float LASER_RADIUS = 0.0125f;
    private static final float LASER_GLOW_RADIUS = 0.01375f;

    public LaserProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(LaserProjectile entity) {
        return LASER_TEXTURE;
    }

    public boolean shouldRender(LaserProjectile pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    protected Vector3f getBeamOffset() {
        return new Vector3f(0.2f, 0.25f, 0.07f);
    }

    protected float getLaserRadius() {
        return 0.0125f;
    }

    protected float getLaserGlowRadius() {
        return 0.01375f;
    }

    public void render(LaserProjectile projectile, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light) {
        float prog = (float)projectile.f_19797_ / (float)projectile.getLife();
        double fadingValue = Math.sin(Math.sqrt(prog) * Math.PI);
        float radius = (float)((double)this.getLaserRadius() * fadingValue * 2.0);
        float glowRadius = (float)((double)this.getLaserGlowRadius() * fadingValue * 2.0);
        int shooterId = projectile.getShooterId();
        Entity shooter = Minecraft.m_91087_().f_91073_.m_6815_(shooterId);
        if (shooter == null) {
            return;
        }
        Vec3 playerPos = projectile.getEndVec();
        Vec3 laserPos = shooter.m_20299_(partialTicks);
        Vec3 pos = playerPos.m_82546_(laserPos);
        Vector3f offset = this.getBeamOffset();
        float distance = projectile.getDistance() - offset.y;
        pos = pos.m_82541_();
        float yPos = (float)Math.acos(pos.f_82480_);
        float xzPos = (float)Math.atan2(pos.f_82481_, pos.f_82479_);
        int side = projectile.isRightHand() ? -1 : 1;
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - xzPos) * 57.295776f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(yPos * 57.295776f));
        poseStack.m_252880_((float)side * offset.x, offset.y, offset.z);
        long gameTime = projectile.m_9236_().m_46467_();
        boolean yOffset = false;
        Rgba color = new Rgba(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.renderBeam(poseStack, bufferSource, this.getTextureLocation(projectile), partialTicks, 1.0f, gameTime, (float)yOffset, distance, color, radius, glowRadius);
        poseStack.m_85849_();
    }
}

