/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.MeleeMode;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageMeleeAttack;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl", value={Dist.CLIENT})
public class ClientMeleeHandler {
    private static final Map<Pair<LivingEntity, InteractionHand>, ClientMeleeTracker> TRACKER_MAP = new HashMap<Pair<LivingEntity, InteractionHand>, ClientMeleeTracker>();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START) {
                for (Pair<LivingEntity, InteractionHand> pair : TRACKER_MAP.keySet()) {
                    ClientMeleeHandler.onEntityTick((LivingEntity)pair.getFirst(), (InteractionHand)pair.getSecond());
                }
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static ClientMeleeTracker getTracker(LivingEntity shooter, InteractionHand hand) {
        return TRACKER_MAP.get(Pair.of((Object)shooter, (Object)hand));
    }

    public static boolean isOnDelay(LivingEntity shooter, InteractionHand hand) {
        Pair key = Pair.of((Object)shooter, (Object)hand);
        return TRACKER_MAP.containsKey(key) && ClientMeleeHandler.TRACKER_MAP.get((Object)key).delayTick > 0;
    }

    public static boolean isOnCooldown(LivingEntity shooter, InteractionHand hand) {
        Pair key = Pair.of((Object)shooter, (Object)hand);
        return TRACKER_MAP.containsKey(key) && ClientMeleeHandler.TRACKER_MAP.get((Object)key).cooldownTick > 0;
    }

    public static void addTracker(WeaponData data, InteractionHand hand) {
        LivingEntity entity = data.wielder;
        ItemStack gun = data.weapon;
        SyncedDataKey<LivingEntity, Boolean> doMeleeKey = ModSyncedDataKeys.getMeleeKey(hand);
        Boolean doMelee = (Boolean)doMeleeKey.getValue((Entity)entity);
        assert (gun != null && entity != null);
        if (WeaponModifierHelper.isWeaponItem(gun) && WeaponModifierHelper.canMelee(data) && !TRACKER_MAP.containsKey(Pair.of((Object)entity, (Object)hand)) && !doMelee.booleanValue()) {
            TRACKER_MAP.put((Pair<LivingEntity, InteractionHand>)Pair.of((Object)entity, (Object)hand), new ClientMeleeTracker(data));
            PacketHandler.getPlayChannel().sendToServer(new C2SMessageMeleeAttack(hand, data.weaponMode));
        }
    }

    public static void handleInput(WeaponData data, InteractionHand hand, KeyMapping key) {
        LivingEntity shooter = data.wielder;
        if (ClientMeleeHandler.isMelee(data) && !EquipTracker.isEquiping(shooter, hand) && !shooter.m_5833_()) {
            ClientMeleeHandler.attack(data, hand);
            MeleeMode mode = WeaponModifierHelper.getMeleeMode(data);
            if (mode == MeleeMode.SINGLE) {
                key.m_7249_(false);
            }
        }
    }

    private static void attack(WeaponData data, InteractionHand hand) {
        LivingEntity shooter = data.wielder;
        Pair key = new Pair((Object)shooter, (Object)hand);
        if (!TRACKER_MAP.containsKey(key)) {
            ClientMeleeHandler.addTracker(data, hand);
        }
    }

    private static void onEntityTick(LivingEntity shooter, InteractionHand hand) {
        ClientMeleeTracker tracker = TRACKER_MAP.get(Pair.of((Object)shooter, (Object)hand));
        if (tracker.delayTick > 0) {
            --tracker.delayTick;
        } else if (tracker.cooldownTick > 0) {
            --tracker.cooldownTick;
        } else if (tracker.cooldownTick == 0) {
            ClientMeleeHandler.stopMelee(shooter, hand);
        }
    }

    private static void stopMelee(LivingEntity entity, InteractionHand arm) {
        TRACKER_MAP.remove(Pair.of((Object)entity, (Object)arm));
    }

    private static boolean isMelee(WeaponData data) {
        return WeaponModifierHelper.getWeaponAction(data) == WeaponAction.MELEE;
    }

    public static class ClientMeleeTracker {
        private int delayTick;
        private int cooldownTick;
        private final WeaponData data;

        public ClientMeleeTracker(WeaponData data) {
            this.cooldownTick = WeaponModifierHelper.getMeleeCooldown(data);
            this.delayTick = WeaponModifierHelper.getMeleeDelay(data);
            this.data = data;
        }

        public WeaponData getData() {
            return this.data;
        }
    }
}

