/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.holders;

import com.nukateam.ntgl.common.data.holders.ResourceHolder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ProjectileType
extends ResourceHolder {
    public static ProjectileType BULLET = new ProjectileType("bullet");
    public static ProjectileType GRENADE = new ProjectileType("grenade");
    public static ProjectileType STUN_GRENADE = new ProjectileType("stun_grenade");
    public static ProjectileType MISSILE = new ProjectileType("missile");
    public static ProjectileType LASER = new ProjectileType("laser");
    public static ProjectileType TESLA = new ProjectileType("tesla");
    public static ProjectileType FIRE = new ProjectileType("fire");
    public static ProjectileType CONTINUOUS_LASER = new ProjectileType("continuous_laser");
    public static ProjectileType ARROW_LIKE = new ProjectileType("arrow_like");
    private static final Map<ResourceLocation, ProjectileType> typeMap = new HashMap<ResourceLocation, ProjectileType>();

    public ProjectileType(ResourceLocation id) {
        super(id);
    }

    public ProjectileType(String name) {
        super(name);
    }

    public static void registerType(ProjectileType mode) {
        typeMap.putIfAbsent(mode.getId(), mode);
    }

    public static ProjectileType getType(ResourceLocation id) {
        return typeMap.getOrDefault(id, BULLET);
    }

    public static ProjectileType getType(String path) {
        ResourceLocation id = ResourceLocation.m_135820_((String)path);
        return ProjectileType.getType(id);
    }

    static {
        ProjectileType.registerType(BULLET);
        ProjectileType.registerType(GRENADE);
        ProjectileType.registerType(STUN_GRENADE);
        ProjectileType.registerType(MISSILE);
        ProjectileType.registerType(LASER);
        ProjectileType.registerType(TESLA);
        ProjectileType.registerType(FIRE);
        ProjectileType.registerType(CONTINUOUS_LASER);
        ProjectileType.registerType(ARROW_LIKE);
    }
}

