/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.foundation.entity.AbstractBeamProjectile;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.foundation.init.Projectiles;
import com.nukateam.ntgl.common.util.util.math.ExtendedEntityRayTraceResult;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TeslaProjectile
extends AbstractBeamProjectile {
    public static final int TTL = 10;
    public static final float CHAIN_RANGE = 8.0f;
    public static final int CHAIN_TARGETS = 4;
    public static final float CHAIN_DAMAGE_FACTOR = 0.75f;
    private static final float CREEPER_POWER_CHANCE = 0.3f;
    protected long seed = 0L;
    public float angle = 0.0f;
    protected int chainTargets = 4;
    protected Entity prevTarget = null;
    protected EntityType<? extends ProjectileEntity> entityType = null;
    public static final double D2R = Math.PI / 180;
    public static final double R2D = 57.29577951308232;

    public TeslaProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.seed = worldIn.f_46441_.m_188505_();
        this.entityType = entityType;
    }

    public TeslaProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn, WeaponData data) {
        this(entityType, worldIn, data, 4);
    }

    public TeslaProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn, WeaponData data, int chainTargets) {
        super(entityType, worldIn, data);
        this.chainTargets = chainTargets;
        this.entityType = entityType;
        this.trace();
    }

    public TeslaProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn, Entity source, LivingEntity target, WeaponData data, int chainTargets) {
        super(entityType, worldIn, data);
        this.maxTicks = (short)this.life;
        this.chainTargets = chainTargets;
        this.prevTarget = target;
        this.m_6034_(source.m_20185_(), source.m_20186_() + (double)(source.m_20192_() * 0.5f), source.m_20189_());
        Vec3 src = this.m_20182_();
        Vec3 tgt = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20192_() * 0.5f), target.m_20189_());
        Vec3 dir = tgt.m_82546_(src).m_82541_();
        this.distance = (float)src.m_82554_(tgt);
        this.laserPitch = (float)(Math.asin(-dir.f_82480_) * 57.29577951308232);
        this.laserYaw = (float)(Math.atan2(dir.f_82479_, dir.f_82481_) * 57.29577951308232);
        this.m_146926_(this.laserPitch);
        this.m_146922_(this.laserYaw);
        this.m_20334_(dir.f_82479_ * (double)this.projectile.getSpeed(), dir.f_82480_ * (double)this.projectile.getSpeed(), dir.f_82481_ * (double)this.projectile.getSpeed());
        this.trace();
        if (this.distance <= 0.0f) {
            this.distance = this.projectile.getSpeed();
        }
    }

    @Override
    protected void handleBlockBreaking(BlockPos pos, BlockState state) {
    }

    @Override
    protected void onHitEntity(ExtendedEntityRayTraceResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        LivingEntity entity = this.getShooter();
        if (!this.m_9236_().f_46443_) {
            LivingEntity nextTarget;
            if (entity instanceof Creeper) {
                Creeper creeper = (Creeper)entity;
                this.powerCreeper(creeper);
            }
            if (this.chainTargets > 0 && (nextTarget = this.findNextTarget((Entity)entity)) != null) {
                TeslaProjectile projectile = new TeslaProjectile((EntityType<? extends ProjectileEntity>)((EntityType)Projectiles.TESLA_PROJECTILE.get()), this.m_9236_(), (Entity)entity, nextTarget, this.weaponData, this.chainTargets - 1);
                this.m_9236_().m_7967_((Entity)projectile);
            }
        }
    }

    public float getCreeperPowerChance() {
        return 0.3f;
    }

    private void powerCreeper(Creeper creeper) {
        if (this.f_19796_.m_188501_() <= this.getCreeperPowerChance()) {
            CompoundTag nbt = creeper.serializeNBT();
            nbt.m_128379_("powered", true);
            creeper.deserializeNBT(nbt);
        }
    }

    private LivingEntity findNextTarget(Entity lastTarget) {
        List list = this.m_9236_().m_6249_(lastTarget, new AABB(lastTarget.m_20185_() - 8.0, lastTarget.m_20186_() - 8.0, lastTarget.m_20189_() - 8.0, lastTarget.m_20185_() + 8.0, lastTarget.m_20186_() + 8.0, lastTarget.m_20189_() + 8.0), PROJECTILE_TARGETS);
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            double distance = livingEntity.m_20275_(lastTarget.m_20185_(), lastTarget.m_20186_() + (double)(lastTarget.m_20192_() * 0.5f), lastTarget.m_20189_());
            if (!((distance = Math.sqrt(distance)) < 8.0) || !livingEntity.m_6084_() || livingEntity == lastTarget || livingEntity.equals((Object)this.shooter) || livingEntity.equals((Object)this.prevTarget)) continue;
            Vec3 from = new Vec3(lastTarget.m_20185_(), lastTarget.m_20186_() + (double)(lastTarget.m_20192_() * 0.5f), lastTarget.m_20189_());
            Vec3 to = new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20192_() * 0.5f), livingEntity.m_20189_());
            ClipContext context = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
            BlockHitResult raytraceResult = TeslaProjectile.rayTraceBlocks(this.m_9236_(), context, IGNORE_LEAVES);
            return livingEntity;
        }
        return null;
    }
}

