/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity.projectile;

import com.nukateam.ntgl.client.model.gibs.ModelGibs;
import com.nukateam.ntgl.common.data.enums.DeathType;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class GoreData
implements INBTSerializable<CompoundTag> {
    @Nullable
    public ModelGibs model = null;
    @Nullable
    public ResourceLocation texture = null;
    public float particleScale = 1.0f;
    public float gravity;
    public int bloodColorR;
    public int bloodColorG;
    public int bloodColorB;
    public boolean showBlood = true;
    public SoundEvent sound = (SoundEvent)ModSounds.DEATH_GORE.get();
    public DeathType deathType = DeathType.DEFAULT;
    public float minPartScale = 1.0f;
    public float maxPartScale = 1.0f;

    public GoreData() {
    }

    public GoreData(ModelGibs model, int bloodColorR, int bloodColorG, int bloodColorB) {
        this.model = model;
        this.bloodColorR = bloodColorR;
        this.bloodColorG = bloodColorG;
        this.bloodColorB = bloodColorB;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.texture != null) {
            tag.m_128359_("texture", this.texture.toString());
        }
        tag.m_128350_("gravity", this.gravity);
        tag.m_128405_("bloodColorR", this.bloodColorR);
        tag.m_128405_("bloodColorG", this.bloodColorG);
        tag.m_128405_("bloodColorB", this.bloodColorB);
        tag.m_128379_("showBlood", this.showBlood);
        tag.m_128405_("deathType", this.deathType.getValue());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("texture")) {
            this.texture = new ResourceLocation(tag.m_128461_("texture"));
        }
        if (tag.m_128441_("gravity")) {
            this.gravity = tag.m_128457_("gravity");
        }
        if (tag.m_128441_("bloodColorR")) {
            this.bloodColorR = tag.m_128451_("bloodColorR");
        }
        if (tag.m_128441_("bloodColorG")) {
            this.bloodColorG = tag.m_128451_("bloodColorG");
        }
        if (tag.m_128441_("bloodColorB")) {
            this.bloodColorB = tag.m_128451_("bloodColorB");
        }
        if (tag.m_128441_("showBlood")) {
            this.showBlood = tag.m_128471_("showBlood");
        }
        if (tag.m_128441_("deathType")) {
            this.deathType = DeathType.getById(tag.m_128451_("deathType"));
        }
    }

    public int getNumGibs() {
        return this.model != null ? this.model.getNumGibs() : 0;
    }

    public GoreData setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public GoreData setSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    public void setRandomScale(float min, float max) {
        this.minPartScale = min;
        this.maxPartScale = max;
    }
}

