/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.network.ForgeNetwork;
import com.nukateam.ntgl.common.network.IMessage;
import com.nukateam.ntgl.common.network.message.C2SMessageAim;
import com.nukateam.ntgl.common.network.message.C2SMessageAttachments;
import com.nukateam.ntgl.common.network.message.C2SMessageCraft;
import com.nukateam.ntgl.common.network.message.C2SMessageGrenade;
import com.nukateam.ntgl.common.network.message.C2SMessageHandAction;
import com.nukateam.ntgl.common.network.message.C2SMessageMeleeAttack;
import com.nukateam.ntgl.common.network.message.C2SMessagePreFireSound;
import com.nukateam.ntgl.common.network.message.C2SMessageReload;
import com.nukateam.ntgl.common.network.message.C2SMessageShoot;
import com.nukateam.ntgl.common.network.message.C2SMessageShooting;
import com.nukateam.ntgl.common.network.message.C2SMessageUnload;
import com.nukateam.ntgl.common.network.message.S2CMessageBlood;
import com.nukateam.ntgl.common.network.message.S2CMessageEntityDeath;
import com.nukateam.ntgl.common.network.message.S2CMessageEntityDeathFx;
import com.nukateam.ntgl.common.network.message.S2CMessageGunSound;
import com.nukateam.ntgl.common.network.message.S2CMessagePlayerAnimation;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileExplosion;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitBlock;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitEntity;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitFluid;
import com.nukateam.ntgl.common.network.message.S2CMessageReload;
import com.nukateam.ntgl.common.network.message.S2CMessageStunGrenade;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAmmo;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAttachments;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateWeapons;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static int packetId = 0;
    public static final SimpleChannel PLAY_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ResourceLocation.m_214293_((String)"ntgl", (String)"play")).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();

    public static ForgeNetwork getPlayChannel() {
        return new ForgeNetwork(PLAY_CHANNEL);
    }

    public static void init() {
        PacketHandler.registerPlayMessage(C2SMessageAim.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageReload.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageShoot.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageUnload.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageCraft.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageAttachments.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageShooting.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessagePreFireSound.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageHandAction.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageMeleeAttack.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(C2SMessageGrenade.class, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.registerPlayMessage(S2CMessagePlayerAnimation.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageEntityDeath.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageEntityDeathFx.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageReload.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageStunGrenade.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageUpdateWeapons.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageUpdateAmmo.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageUpdateAttachments.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageBlood.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageGunSound.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageProjectileHitBlock.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageProjectileHitEntity.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageProjectileHitFluid.class, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.registerPlayMessage(S2CMessageProjectileExplosion.class, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <T extends IMessage<T>> void registerPlayMessage(Class<T> messageClass, @Nullable NetworkDirection direction) {
        try {
            Constructor<T> constructor = messageClass.getDeclaredConstructor(new Class[0]);
            IMessage message = (IMessage)constructor.newInstance(new Object[0]);
            PLAY_CHANNEL.registerMessage(packetId++, messageClass, message::encode, message::decode, (msg, messageContext) -> message.handle(msg, (NetworkEvent.Context)messageContext.get()), Optional.ofNullable(direction));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The message %s is missing an empty parameter constructor", messageClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access the constructor of %s. Make sure the constructor is public.", messageClass.getName()), e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void sendAnimation(LivingEntity entity, InteractionHand hand, AnimationType animation) {
        LevelLocation levelLoc = LevelLocation.create((Level)entity.m_9236_(), (BlockPos)entity.m_20183_());
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> levelLoc, new S2CMessagePlayerAnimation(entity.m_19879_(), animation, hand));
    }
}

