/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.nukateam.ntgl.client.handlers.ClientPlayHandler;
import com.nukateam.ntgl.common.network.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class S2CMessageGunSound
implements IMessage<S2CMessageGunSound> {
    private ResourceLocation id;
    private SoundSource category;
    private float x;
    private float y;
    private float z;
    private float volume;
    private float pitch;
    private int shooterId;
    private boolean reload;

    public S2CMessageGunSound() {
    }

    public S2CMessageGunSound(ResourceLocation id, SoundSource category, LivingEntity shooter, float volume, float pitch, boolean reload) {
        this.id = id;
        this.category = category;
        this.x = (float)shooter.m_20182_().f_82479_;
        this.y = (float)shooter.m_20182_().f_82480_;
        this.z = (float)shooter.m_20182_().f_82481_;
        this.volume = volume;
        this.pitch = pitch;
        this.shooterId = shooter.m_19879_();
        this.reload = reload;
    }

    public S2CMessageGunSound(ResourceLocation id, SoundSource category, Vec3 position, float volume, float pitch, int shooterId, boolean reload) {
        this.id = id;
        this.category = category;
        this.x = (float)position.f_82479_;
        this.y = (float)position.f_82480_;
        this.z = (float)position.f_82481_;
        this.volume = volume;
        this.pitch = pitch;
        this.shooterId = shooterId;
        this.reload = reload;
    }

    public S2CMessageGunSound(ResourceLocation id, SoundSource category, float x, float y, float z, float volume, float pitch, int shooterId, boolean reload) {
        this.id = id;
        this.category = category;
        this.x = x;
        this.y = y;
        this.z = z;
        this.volume = volume;
        this.pitch = pitch;
        this.shooterId = shooterId;
        this.reload = reload;
    }

    @Override
    public void encode(S2CMessageGunSound message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.id);
        buffer.m_130068_((Enum)message.category);
        buffer.writeFloat(message.x);
        buffer.writeFloat(message.y);
        buffer.writeFloat(message.z);
        buffer.writeFloat(message.volume);
        buffer.writeFloat(message.pitch);
        buffer.writeInt(message.shooterId);
        buffer.writeBoolean(message.reload);
    }

    @Override
    public S2CMessageGunSound decode(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        SoundSource category = (SoundSource)buffer.m_130066_(SoundSource.class);
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        float z = buffer.readFloat();
        float volume = buffer.readFloat();
        float pitch = buffer.readFloat();
        int shooterId = buffer.readInt();
        boolean reload = buffer.readBoolean();
        return new S2CMessageGunSound(id, category, x, y, z, volume, pitch, shooterId, reload);
    }

    @Override
    public void handle(S2CMessageGunSound message, NetworkEvent.Context supplier) {
        supplier.enqueueWork(() -> ClientPlayHandler.handleMessageGunSound(message));
        supplier.setPacketHandled(true);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public SoundSource getCategory() {
        return this.category;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public boolean isReload() {
        return this.reload;
    }
}

