/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.helpers.compatibility;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class SubtleEffectsHelper {
    public static boolean doSplashEffect(Entity entity, Vec3 pos, boolean inLava) {
        Vec3 delta = entity.m_20184_();
        ParticleType particle = inLava ? (ParticleType)ModParticles.LAVA_SPLASH_EMITTER.get() : (ParticleType)ModParticles.WATER_SPLASH_EMITTER.get();
        float velocity = (float)delta.m_82553_();
        if (!ModConfigs.ENTITIES.splashes.splashEffects) {
            return false;
        }
        SplashEmitterParticleOptions splashEmitter = new SplashEmitterParticleOptions(particle, entity.m_20205_(), entity.m_20206_() * velocity, -1.0f, -1);
        entity.m_9236_().m_6485_((ParticleOptions)splashEmitter, true, pos.m_7096_(), pos.m_7098_() + 0.01, pos.m_7094_(), 0.0, 0.0, 0.0);
        return true;
    }

    public static boolean doSplashEffect(Vec3 pos, float size, float speed, boolean isInLava) {
        float ratio;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ParticleType particle = isInLava ? (ParticleType)ModParticles.LAVA_SPLASH_EMITTER.get() : (ParticleType)ModParticles.WATER_SPLASH_EMITTER.get();
        float f = ratio = isInLava ? 2.0f : 1.0f;
        if (!ModConfigs.ENTITIES.splashes.splashEffects) {
            return false;
        }
        SplashEmitterParticleOptions splashEmitter = new SplashEmitterParticleOptions(particle, size, size * speed / ratio, -1.0f, -1);
        level.m_6485_((ParticleOptions)splashEmitter, true, pos.m_7096_(), pos.m_7098_() + 0.01, pos.m_7094_(), 0.0, 0.0, 0.0);
        return true;
    }

    public static void doExplosionSplash(Level level, float radius, Vec3 position) {
        BlockPos pos;
        FluidState fluidState;
        if (level.f_46443_ && ModConfigs.ENTITIES.splashes.explosionsCauseSplashes && !(fluidState = level.m_6425_(pos = BlockPos.m_274446_((Position)position))).m_76178_()) {
            int blockY;
            int y = blockY = pos.m_123342_();
            while ((float)y < (float)blockY + radius + 1.0f) {
                BlockPos currentPos = pos.m_175288_(y);
                FluidState currentFluidState = level.m_6425_(currentPos);
                if (!fluidState.m_76152_().m_6212_(currentFluidState.m_76152_())) {
                    ParticleType type;
                    if (level.m_8055_(currentPos).m_60804_((BlockGetter)level, currentPos)) {
                        return;
                    }
                    Object object = fluidState.m_205070_(FluidTags.f_13131_) ? (ParticleType)ModParticles.WATER_SPLASH_EMITTER.get() : (type = fluidState.m_205070_(FluidTags.f_13132_) ? (ParticleType)ModParticles.LAVA_SPLASH_EMITTER.get() : null);
                    if (type != null) {
                        BlockPos surfacePos = currentPos.m_7495_();
                        FluidState surfaceFluidState = level.m_6425_(surfacePos);
                        float scale = radius - (float)(y - blockY) / radius;
                        level.m_6485_((ParticleOptions)new SplashEmitterParticleOptions(type, scale, scale * (scale * 0.1f), -1.0f, -1), true, position.f_82479_, (double)((float)surfacePos.m_123342_() + surfaceFluidState.m_76155_((BlockGetter)level, surfacePos)) + 0.01, position.f_82481_, 0.0, 0.0, 0.0);
                    }
                    return;
                }
                ++y;
            }
        }
    }
}

