/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.trackers;

import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.event.GunReloadEvent;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageReload;
import com.nukateam.ntgl.common.util.helpers.context.IAmmoContext;
import com.nukateam.ntgl.common.util.util.InventoryUtil;
import com.nukateam.ntgl.common.util.util.LivingEntityUtils;
import com.nukateam.ntgl.common.util.util.StackUtils;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ntgl")
public class ReloadTracker {
    private static final Map<LivingEntity, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<LivingEntity, ReloadTracker>();
    private final int startTick;
    private final LivingEntity shooter;
    private int slot = 0;
    private final InteractionHand arm;
    private final ItemStack weapon;
    private final WeaponConfig weaponConfig;
    public int reloadTick;
    public boolean isStart = false;
    public boolean isEnd = false;

    private ReloadTracker(LivingEntity entity, InteractionHand arm) {
        this.startTick = entity.f_19797_;
        this.arm = arm;
        this.weapon = entity.m_21120_(arm);
        IWeapon weaponItem = (IWeapon)this.weapon.m_41720_();
        this.weaponConfig = weaponItem.getModifiedConfig(this.weapon);
        this.shooter = entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.slot = arm == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
        }
        WeaponData data = new WeaponData(this.weapon, entity);
        this.reloadTick = WeaponModifierHelper.getReloadTime(data);
        LoadingType loadingType = WeaponModifierHelper.getLoadingType(data);
        if (loadingType == LoadingType.PER_CARTRIDGE) {
            ModSyncedDataKeys.RELOAD_START.setValue((Entity)entity, (Object)true);
            this.reloadTick = WeaponModifierHelper.getReloadStart(data);
            this.isStart = true;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().f_46443_) {
                Player player = event.player;
                ReloadTracker.handTick((LivingEntity)player);
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START) {
                for (LivingEntity entity : RELOAD_TRACKER_MAP.keySet()) {
                    if (entity instanceof Player) continue;
                    ReloadTracker.handTick(entity);
                }
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> RELOAD_TRACKER_MAP.remove(event.getEntity()));
        }
    }

    private boolean isSameWeapon(LivingEntity entity) {
        if (this.arm == InteractionHand.MAIN_HAND) {
            return !this.weapon.m_41619_() && entity.m_21205_() == this.weapon;
        }
        return !this.weapon.m_41619_() && entity.m_21206_() == this.weapon;
    }

    private boolean isWeaponFull() {
        WeaponData data = new WeaponData(this.weapon, this.shooter);
        return WeaponStateHelper.getAmmoCount(data) >= WeaponModifierHelper.getMaxAmmo(data);
    }

    private boolean hasNoAmmo(LivingEntity player) {
        return !InventoryUtil.hasAmmo(player, this.weapon);
    }

    private static void addOrDropStack(Player player, ItemStack usedMagazine) {
        if (!player.m_36356_(usedMagazine)) {
            player.m_36176_(usedMagazine, false);
        }
    }

    private static void handTick(LivingEntity entity) {
        if (((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)entity)).booleanValue()) {
            ReloadTracker.handTick(entity, InteractionHand.MAIN_HAND);
        } else if (((Boolean)ModSyncedDataKeys.RELOADING_LEFT.getValue((Entity)entity)).booleanValue()) {
            ReloadTracker.handTick(entity, InteractionHand.OFF_HAND);
        } else if (RELOAD_TRACKER_MAP.containsKey(entity)) {
            RELOAD_TRACKER_MAP.remove(entity);
        }
    }

    private static void handTick(LivingEntity shooter, InteractionHand arm) {
        if (ReloadTracker.addTracker(shooter, arm)) {
            return;
        }
        ReloadTracker tracker = RELOAD_TRACKER_MAP.get(shooter);
        WeaponData data = new WeaponData(tracker.weapon, shooter);
        LoadingType loadingType = WeaponModifierHelper.getLoadingType(data);
        WeaponConfig gun = tracker.weaponConfig;
        boolean isSameWeapon = !tracker.isSameWeapon(shooter);
        boolean isWeaponFull = tracker.isWeaponFull();
        boolean hasNoAmmo = tracker.hasNoAmmo(shooter);
        if (isSameWeapon || !tracker.isEnd && (isWeaponFull || hasNoAmmo)) {
            RELOAD_TRACKER_MAP.remove(shooter);
            SyncedDataKey<LivingEntity, Boolean> reloadKey = ModSyncedDataKeys.getReloadKey(arm);
            reloadKey.setValue((Entity)shooter, (Object)false);
        } else if (loadingType == LoadingType.MAGAZINE) {
            if (tracker.reloadTick > 0) {
                --tracker.reloadTick;
            }
            if (tracker.reloadTick == 0) {
                tracker.reloadMagazine(shooter);
                ReloadTracker.stopReloading(data, gun, arm);
            }
        } else if (loadingType == LoadingType.PER_CARTRIDGE) {
            if (tracker.reloadTick > 0) {
                --tracker.reloadTick;
            }
            if (tracker.reloadTick == 0) {
                if (tracker.isStart) {
                    ReloadTracker.resetTracker(tracker, data);
                    tracker.isStart = false;
                    ModSyncedDataKeys.RELOAD_START.setValue((Entity)shooter, (Object)false);
                } else {
                    tracker.addCartridge(shooter);
                    if (tracker.isWeaponFull() || tracker.hasNoAmmo(shooter)) {
                        if (tracker.isEnd) {
                            ModSyncedDataKeys.RELOAD_END.setValue((Entity)shooter, (Object)false);
                            ReloadTracker.stopReloading(data, gun, arm);
                        } else {
                            tracker.isEnd = true;
                            ModSyncedDataKeys.RELOAD_END.setValue((Entity)shooter, (Object)true);
                            tracker.reloadTick = WeaponModifierHelper.getReloadEnd(data);
                        }
                    } else {
                        ReloadTracker.resetTracker(tracker, data);
                    }
                }
            }
        }
    }

    private void reloadMagazine(LivingEntity entity) {
        Player player;
        WeaponData data = new WeaponData(this.weapon, entity);
        if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
            if (WeaponStateHelper.getProjectileConfig(data).isMagazineMode()) {
                this.addMagazine(entity);
            } else {
                this.addAmmo(entity);
            }
        } else {
            WeaponStateHelper.setMaxAmmo(data);
        }
    }

    private void addCartridge(LivingEntity entity) {
        Player player;
        WeaponData gunData = new WeaponData(this.weapon, this.shooter);
        int reloadAmount = WeaponModifierHelper.getReloadAmount(gunData);
        if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
            this.addAmmo(entity, reloadAmount);
        } else {
            WeaponStateHelper.addAmmo(gunData, reloadAmount);
        }
    }

    private void addAmmo(LivingEntity entity) {
        WeaponData data = new WeaponData(this.weapon, entity);
        int amount = WeaponModifierHelper.getMaxAmmo(data);
        while (this.isNotReloaded(entity)) {
            this.addAmmo(entity, amount);
        }
    }

    private void addAmmo(LivingEntity entity, int amount) {
        IAmmoContext context = InventoryUtil.findAmmo(entity, this.weapon);
        ItemStack ammo = context.stack();
        WeaponData data = new WeaponData(this.weapon, entity);
        AmmoHolder ammoHandler = WeaponStateHelper.getCurrentAmmo(data);
        if (!ammo.m_41619_()) {
            CompoundTag tag = this.weapon.m_41783_();
            int value = ammoHandler.getValue(ammo);
            int currentAmount = WeaponStateHelper.getAmmoCount(data);
            amount = Math.min(ammo.m_41613_() * value, amount);
            if (tag != null) {
                WeaponData gunData = new WeaponData(this.weapon, this.shooter);
                int maxAmmo = WeaponModifierHelper.getMaxAmmo(gunData);
                amount = Math.min(amount, maxAmmo - tag.m_128451_("AmmoCount"));
                WeaponStateHelper.addAmmo(gunData, amount);
            }
            context.shrink(amount, ammoHandler, entity);
        }
    }

    private boolean isNotReloaded(LivingEntity entity) {
        WeaponData data = new WeaponData(this.weapon, entity);
        CompoundTag tag = this.weapon.m_41783_();
        boolean hasAmmo = InventoryUtil.hasAmmo(entity, this.weapon);
        int ammoCount = WeaponStateHelper.getAmmoCount(data);
        int ammoCapacity = WeaponModifierHelper.getMaxAmmo(data);
        return hasAmmo && ammoCount < ammoCapacity;
    }

    private void addMagazine(LivingEntity entity) {
        WeaponData data = new WeaponData(this.weapon, entity);
        AmmoHolder ammoHolder = WeaponStateHelper.getCurrentAmmo(data);
        IAmmoContext context = InventoryUtil.findMagazine(entity, this.weapon);
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            int amount = StackUtils.getDurability(ammo);
            CompoundTag tag = this.weapon.m_41783_();
            amount = Math.min(WeaponModifierHelper.getMaxAmmo(data), amount);
            if (tag != null) {
                int maxAmmo = WeaponModifierHelper.getMaxAmmo(data);
                int currentAmmo = tag.m_128451_("AmmoCount");
                if (currentAmmo > 0 && ammoHolder.canReturnAmmo()) {
                    ItemStack usedMagazine = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ammoHolder.getId()));
                    StackUtils.setDurability(usedMagazine, currentAmmo);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        ReloadTracker.addOrDropStack(player, usedMagazine);
                    }
                }
                tag.m_128405_("AmmoCount", amount);
            }
            context.shrink(1, ammoHolder, entity);
        }
    }

    private static void resetTracker(ReloadTracker tracker, WeaponData data) {
        tracker.reloadTick = WeaponModifierHelper.getReloadTime(data);
    }

    public static void startReloading(LivingEntity entity, InteractionHand arm) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = ModSyncedDataKeys.getReloadKey(arm);
        reloadKey.setValue((Entity)entity, (Object)true);
        ReloadTracker.addTracker(entity, arm);
    }

    private static boolean addTracker(LivingEntity entity, InteractionHand arm) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = ModSyncedDataKeys.getReloadKey(arm);
        Item gunItem = entity.m_21120_(arm).m_41720_();
        if (!RELOAD_TRACKER_MAP.containsKey(entity)) {
            if (!(gunItem instanceof IWeapon)) {
                reloadKey.setValue((Entity)entity, (Object)false);
                return true;
            }
            RELOAD_TRACKER_MAP.put(entity, new ReloadTracker(entity, arm));
        }
        return false;
    }

    private static void stopReloading(WeaponData data, WeaponConfig weaponConfig, InteractionHand hand) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = ModSyncedDataKeys.getReloadKey(hand);
        LivingEntity entity = data.wielder;
        RELOAD_TRACKER_MAP.remove(entity);
        reloadKey.setValue((Entity)entity, (Object)false);
        LivingEntity finalPlayer = entity;
        InteractionHand oppositeHand = LivingEntityUtils.getOppositeHand(hand);
        ItemStack oppositeStack = entity.m_21120_(oppositeHand);
        if (hand == InteractionHand.MAIN_HAND && oppositeStack.m_41720_() instanceof IWeapon && !WeaponModifierHelper.isWeaponFull(new WeaponData(oppositeStack, entity))) {
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)entity, new S2CMessageReload(true, oppositeHand));
        }
        MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((Player)((ServerPlayer)entity), data.weapon, hand));
    }
}

