/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.model.GeoModel;

public class AnimationHelper<T extends GeoAnimatable> {
    private final T animatable;
    private final GeoModel model;

    public AnimationHelper(T animatable, GeoModel model) {
        this.animatable = animatable;
        this.model = model;
    }

    @Deprecated
    public void syncAnimation(AnimationState event, String animationName, int targetDuration) {
        float multiplier = (float)this.getSpeedMultiplier(animationName, targetDuration);
        event.setControllerSpeed(multiplier);
    }

    public void syncAnimation(AnimationState event, int targetDuration, String ... animations) {
        double multiplier = this.getSpeedMultiplier(targetDuration, List.of(animations));
        event.setControllerSpeed((float)multiplier);
    }

    public void syncAnimation(AnimationState event, int targetDuration, Iterable<String> animations) {
        double multiplier = this.getSpeedMultiplier(targetDuration, animations);
        event.setControllerSpeed((float)multiplier);
    }

    public double getSpeedMultiplier(double targetDuration, Iterable<String> animations) {
        double generalDuration = 0.0;
        for (String name : animations) {
            generalDuration += this.getAnimationDuration(name);
        }
        return generalDuration / targetDuration;
    }

    public double getSpeedMultiplier(String animationName, double targetDuration) {
        double duration = this.getAnimationDuration(animationName);
        return duration / targetDuration;
    }

    public double getAnimationDuration(String animationName) {
        Animation animation = this.getAnimation(animationName);
        return animation != null ? animation.length() : 1.0;
    }

    public boolean containsAnimation(String animationName) {
        return this.getAnimation(animationName) != null;
    }

    @Nullable
    public Animation getAnimation(String animationName) {
        Map map = GeckoLibCache.getBakedAnimations();
        ResourceLocation animationResource = this.model.getAnimationResource(this.animatable);
        BakedAnimations bakedAnimations = (BakedAnimations)map.get(animationResource);
        return (Animation)bakedAnimations.animations().get(animationName);
    }

    public boolean hasAnimation(String animationName) {
        return this.getAnimation(animationName) != null;
    }
}

