/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchIngredient;
import com.nukateam.ntgl.common.util.helpers.compatibility.backpack.BackpackHelper;
import com.nukateam.ntgl.common.util.helpers.context.AmmoContext;
import com.nukateam.ntgl.common.util.helpers.context.IAmmoContext;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class InventoryUtil {
    public static int getItemStackAmount(Player player, ItemStack find) {
        int count = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !InventoryUtil.areItemStacksEqualIgnoreCount(stack, find)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private static boolean areItemStacksEqualIgnoreCount(ItemStack source, ItemStack target) {
        if (source.m_41720_() != target.m_41720_()) {
            return false;
        }
        if (source.m_41773_() != target.m_41773_()) {
            return false;
        }
        if (source.m_41783_() == null && target.m_41783_() != null) {
            return false;
        }
        return (source.m_41783_() == null || source.m_41783_().equals((Object)target.m_41783_())) && source.areCapsCompatible((CapabilityProvider)target);
    }

    public static boolean hasWorkstationIngredient(Player player, WorkbenchIngredient find) {
        int count = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !find.test(stack)) continue;
            count += stack.m_41613_();
        }
        return find.getCount() <= count;
    }

    public static boolean removeWorkstationIngredient(Player player, WorkbenchIngredient find) {
        int amount = find.getCount();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !find.test(stack)) continue;
            if (amount - stack.m_41613_() < 0) {
                stack.m_41774_(amount);
                return true;
            }
            player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            if ((amount -= stack.m_41613_()) != 0) continue;
            return true;
        }
        return false;
    }

    public static IAmmoContext findPlayerAmmo(Player player, AmmoHolder id) {
        AmmoContext context = InventoryUtil.findAmmo((Container)player.m_150109_(), id);
        if (!context.equals(AmmoContext.NONE)) {
            return context;
        }
        return BackpackHelper.findAmmo(player, id);
    }

    public static AmmoContext findAmmo(Container inventory, AmmoHolder id) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!InventoryUtil.isAmmo(stack, id)) continue;
            return new AmmoContext(stack, inventory);
        }
        return AmmoContext.NONE;
    }

    public static IAmmoContext findPlayerMagazine(Player player, AmmoHolder id) {
        AmmoContext context = InventoryUtil.findMagazine((Container)player.m_150109_(), id);
        if (!context.equals(AmmoContext.NONE)) {
            return context;
        }
        return BackpackHelper.findMagazine(player, id);
    }

    public static AmmoContext findMagazine(Container inventory, AmmoHolder id) {
        ItemStack ammoStack = null;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack foundStack = inventory.m_8020_(i);
            if (!InventoryUtil.isAmmo(foundStack, id)) continue;
            if (foundStack.m_41773_() == 0) {
                return new AmmoContext(foundStack, inventory);
            }
            if (ammoStack != null && !InventoryUtil.hasMoreAmmo(ammoStack, foundStack)) continue;
            ammoStack = foundStack;
        }
        if (ammoStack != null) {
            return new AmmoContext(ammoStack, inventory);
        }
        return AmmoContext.NONE;
    }

    public static boolean isAmmo(ItemStack stack, AmmoHolder id) {
        return stack != null && id.isAcceptable(stack);
    }

    private static boolean hasMoreAmmo(ItemStack first, ItemStack second) {
        return second.m_41773_() < first.m_41773_() && first.m_41773_() < first.m_41776_();
    }

    @NotNull
    public static AmmoContext getCreativeAmmoContext(ResourceLocation id) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        ItemStack ammo = item != null ? new ItemStack((ItemLike)item, Integer.MAX_VALUE) : ItemStack.f_41583_;
        return new AmmoContext(ammo, null);
    }

    public static IAmmoContext findAmmo(AmmoHolder ammoHandler, WeaponData data) {
        LivingEntity livingEntity = data.wielder;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            IAmmoContext context = InventoryUtil.findPlayerAmmo(player, ammoHandler);
            if (context == AmmoContext.NONE) {
                Set<AmmoHolder> set = WeaponModifierHelper.getAmmoItems(data);
                for (AmmoHolder value : set) {
                    if (value.equals(ammoHandler.getId()) || WeaponStateHelper.getAmmoCount(data) != 0 || (context = InventoryUtil.findPlayerAmmo(player, ammoHandler = value)) == AmmoContext.NONE) continue;
                    WeaponStateHelper.setCurrentAmmo(data, ammoHandler.getId());
                    return context;
                }
            }
            return context;
        }
        return AmmoContext.NONE;
    }

    public static IAmmoContext findAmmo(LivingEntity entity, ItemStack weapon) {
        WeaponData data = new WeaponData(weapon, entity);
        AmmoHolder ammoHandler = WeaponStateHelper.getCurrentAmmo(data);
        return InventoryUtil.findAmmo(ammoHandler, data);
    }

    public static IAmmoContext findMagazine(LivingEntity entity, ItemStack weapon) {
        WeaponData data = new WeaponData(weapon, entity);
        AmmoHolder ammoHandler = WeaponStateHelper.getCurrentAmmo(data);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IAmmoContext context = InventoryUtil.findPlayerMagazine(player, ammoHandler);
            if (context == AmmoContext.NONE) {
                Set<AmmoHolder> set = WeaponModifierHelper.getAmmoItems(data);
                for (AmmoHolder value : set) {
                    if (value.equals(ammoHandler) || WeaponStateHelper.getAmmoCount(data) != 0 || (context = InventoryUtil.findPlayerMagazine(player, ammoHandler = value)) == AmmoContext.NONE) continue;
                    WeaponStateHelper.setCurrentAmmo(data, ammoHandler.getId());
                    return context;
                }
            }
            return context;
        }
        return AmmoContext.NONE;
    }

    public static boolean hasAmmo(LivingEntity entity, ItemStack weapon) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
            return !InventoryUtil.findAmmo((LivingEntity)player, weapon).stack().m_41619_();
        }
        return true;
    }
}

