/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import java.util.Random;

public class MathUtil {
    public static float clamp(float value, float min, float max) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    public static double clamp(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int randomInt(Random rand, int min, int max) {
        if (max >= min) {
            return min + rand.nextInt(max - min + 1);
        }
        return max + rand.nextInt(min - max + 1);
    }

    public static float randomFloat(Random rand, float min, float max) {
        return min + rand.nextFloat() * (max - min);
    }

    public static boolean allInRange(int lowerBound, int upperBound, Integer ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= lowerBound && values[i] <= upperBound) continue;
            return false;
        }
        return true;
    }

    public static int min(Integer ... values) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= min) continue;
            min = values[i];
        }
        return min;
    }

    public static int max(Integer ... values) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    public static int getAverageHeight(Integer ... values) {
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i].intValue();
        }
        return (int)Math.round((double)sum / (double)values.length);
    }

    public static float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public static Vec2 polarOffsetXZ(double x, double z, double radius, double angle) {
        return new Vec2(x += radius * Math.cos(angle), z += radius * Math.sin(angle));
    }

    public static class Vec2 {
        public double x;
        public double y;

        public Vec2(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double lenSquared() {
            return this.x * this.x + this.y * this.y;
        }

        public double len() {
            return Math.sqrt(this.lenSquared());
        }

        public void normalize() {
            double len = this.len();
            if (len > 0.0) {
                double f = 1.0 / len;
                this.x *= f;
                this.y *= f;
            }
        }

        public Vec2 getNormalized() {
            double len = this.len();
            if (len > 0.0) {
                double f = 1.0 / len;
                return new Vec2(this.x * f, this.y * f);
            }
            return new Vec2(0.0, 0.0);
        }

        public static Vec2 substract(Vec2 A, Vec2 B) {
            return new Vec2(B.x - A.x, B.y - A.y);
        }

        public static Vec2 add(Vec2 A, Vec2 B) {
            return new Vec2(B.x + A.x, B.y + A.y);
        }
    }
}

