/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.util.util.SetUtils;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import java.util.LinkedHashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ThrowableStateHelper {
    public static final String THROW_MODE = "ThrowMode";

    public static void switchThrowMode(WeaponData data) {
        if (data.weapon.m_41720_() instanceof IThrowable) {
            ItemStack stack = data.weapon;
            LinkedHashSet<ThrowMode> modes = WeaponModifierHelper.getThrowModes(data);
            ThrowMode current = ThrowableStateHelper.getThrowMode(data);
            ThrowMode newMode = SetUtils.cycleSet(modes, current);
            ThrowableStateHelper.setThrowMode(stack, newMode);
        }
    }

    public static ThrowMode getThrowMode(WeaponData data) {
        ItemStack stack = data.weapon;
        LinkedHashSet<ThrowMode> modes = WeaponModifierHelper.getThrowModes(data);
        CompoundTag tag = stack.m_41784_();
        ThrowMode currentMode = null;
        if (tag.m_128425_(THROW_MODE, 8)) {
            currentMode = ThrowMode.getType(tag.m_128461_(THROW_MODE));
        }
        if (currentMode == null || !modes.contains(currentMode)) {
            ThrowableStateHelper.setThrowMode(stack, SetUtils.getFirst(modes));
            return SetUtils.getFirst(modes);
        }
        return currentMode;
    }

    public static void setThrowMode(ItemStack stack, ThrowMode fireMode) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(THROW_MODE, fireMode.toString());
        stack.m_41751_(tag);
    }
}

