/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.attachment.impl.Attachment;
import com.nukateam.ntgl.common.data.config.attachment.Modifiers;
import com.nukateam.ntgl.common.data.config.weapon.AmmoConfig;
import com.nukateam.ntgl.common.data.config.weapon.Fuel;
import com.nukateam.ntgl.common.data.config.weapon.General;
import com.nukateam.ntgl.common.data.config.weapon.Melee;
import com.nukateam.ntgl.common.data.config.weapon.Modules;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.config.weapon.ThrowableConfig;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.config.weapon.WeaponSettings;
import com.nukateam.ntgl.common.data.config.weapon.Zoom;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.data.holders.MeleeMode;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.foundation.item.interfaces.IAmmo;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public class WeaponModifierHelper {
    private static final IWeaponModifier[] EMPTY = new IWeaponModifier[0];
    public static final ProjectileConfig PROJECTILE = new ProjectileConfig();

    @Deprecated
    public static ProjectileConfig getCurrentAmmo(WeaponData data) {
        return WeaponStateHelper.getProjectileConfig(data);
    }

    public static boolean isAuto(WeaponData itemStack) {
        return WeaponStateHelper.getFireMode(itemStack) == FireMode.AUTO;
    }

    public static boolean isWeaponFull(WeaponData data) {
        CompoundTag tag = data.weapon.m_41784_();
        return tag.m_128451_("AmmoCount") >= WeaponModifierHelper.getMaxAmmo(data);
    }

    public static boolean canUseOffhandWeapon(LivingEntity player) {
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        if (!WeaponModifierHelper.isOneHanded(new WeaponData(mainHandItem, player))) {
            return false;
        }
        return WeaponModifierHelper.isOneHanded(new WeaponData(offhandItem, player));
    }

    public static boolean isGun(ItemStack data) {
        Item gunItem = data.m_41720_();
        return gunItem instanceof IWeapon;
    }

    public static WeaponConfig getConfig(WeaponData weaponData) {
        Item item;
        ItemStack stack = weaponData.weapon;
        if (stack != null && (item = stack.m_41720_()) instanceof IWeapon) {
            IWeapon weapon = (IWeapon)item;
            return weapon.getModifiedConfig(stack);
        }
        return new WeaponConfig();
    }

    public static General getGeneral(WeaponData weaponData) {
        WeaponConfig config = WeaponModifierHelper.getConfig(weaponData);
        return config.getGeneral(weaponData.weaponMode);
    }

    public static Melee getMelee(WeaponData weaponData) {
        WeaponConfig config = WeaponModifierHelper.getConfig(weaponData);
        return config.getMelee(weaponData.weaponMode);
    }

    public static Zoom getZoom(WeaponData weaponData) {
        WeaponConfig config = WeaponModifierHelper.getConfig(weaponData);
        return config.getZoom(weaponData.weaponMode);
    }

    public static ThrowableConfig getThrowable(WeaponData weaponData) {
        WeaponConfig config = WeaponModifierHelper.getConfig(weaponData);
        return config.getThrowable(weaponData.weaponMode);
    }

    public static Set<AttachmentType> getAttachmentTypes(WeaponData data) {
        return WeaponModifierHelper.getConfig(data).getModules().getAttachments().keySet();
    }

    public static boolean isThrowable(WeaponData data) {
        return WeaponModifierHelper.getGeneral(data).getAction() == WeaponAction.THROW;
    }

    public static boolean isAlwaysSpread(WeaponData data) {
        AtomicBoolean isAlwaysSpread = new AtomicBoolean(WeaponModifierHelper.getGeneral(data).isAlwaysSpread());
        return isAlwaysSpread.get();
    }

    public static int getMaxAmmo(WeaponData data) {
        AtomicInteger finalMaxAmmo = new AtomicInteger(WeaponModifierHelper.getGeneral(data).getMaxAmmo());
        ProjectileConfig config = WeaponStateHelper.getProjectileConfig(data);
        if (data != null && config != null && data.weapon.m_41720_() instanceof IWeapon && WeaponStateHelper.getProjectileConfig(data).isMagazineMode()) {
            AmmoHolder id = WeaponStateHelper.getCurrentAmmo(data);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id.getId());
            finalMaxAmmo.set(item.getMaxDamage(new ItemStack((ItemLike)item)));
        }
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalMaxAmmo.set(modifier.modifyMaxAmmo(finalMaxAmmo.get(), data)));
        return finalMaxAmmo.get();
    }

    public static boolean isAutoReloading(WeaponData data) {
        AtomicBoolean autoReloading = new AtomicBoolean(WeaponModifierHelper.getGeneral(data).isAutoReloading());
        WeaponModifierHelper.forEachAttachment(data, modifier -> autoReloading.set(modifier.modifyAutoReloading(autoReloading.get(), data)));
        return autoReloading.get();
    }

    public static ResourceLocation getFireSound(WeaponData data) {
        AtomicReference<ResourceLocation> fireSound = new AtomicReference<ResourceLocation>(WeaponModifierHelper.getConfig(data).getSounds().getFire());
        WeaponModifierHelper.forEachAttachment(data, modifier -> fireSound.set(modifier.modifyFireSound((ResourceLocation)fireSound.get(), data)));
        return fireSound.get();
    }

    public static boolean shouldRenderHud(WeaponData data) {
        AtomicBoolean renderHud = new AtomicBoolean(WeaponModifierHelper.getGeneral(data).shouldRenderHud());
        WeaponModifierHelper.forEachAttachment(data, modifier -> renderHud.set(modifier.modifyShouldRenderHud(renderHud.get(), data)));
        return renderHud.get();
    }

    public static LoadingType getLoadingType(WeaponData data) {
        AtomicReference<LoadingType> loadingType = new AtomicReference<LoadingType>(WeaponModifierHelper.getGeneral(data).getLoadingType());
        WeaponModifierHelper.forEachAttachment(data, modifier -> loadingType.set(modifier.modifyLoadingType((LoadingType)loadingType.get(), data)));
        return loadingType.get();
    }

    public static WeaponAction getWeaponAction(WeaponData data) {
        AtomicReference<WeaponAction> value = new AtomicReference<WeaponAction>(WeaponModifierHelper.getGeneral(data).getAction());
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyWeaponAction((WeaponAction)value.get(), data)));
        return value.get();
    }

    public static HashMap<WeaponMode, WeaponSettings> getWeaponModes(WeaponData data) {
        AtomicReference<HashMap<WeaponMode, WeaponSettings>> value = new AtomicReference<HashMap<WeaponMode, WeaponSettings>>(WeaponModifierHelper.getConfig(data).getModes());
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyWeaponModes((HashMap)value.get(), data)));
        return value.get();
    }

    public static int getProjectileAmount(WeaponData data) {
        int gunProjectileAmount = WeaponModifierHelper.getGeneral(data).getProjectileAmount();
        int ammoProjectileAmount = WeaponStateHelper.getProjectileConfig(data).getProjectileAmount();
        AtomicInteger finalProjectileAmount = new AtomicInteger(gunProjectileAmount * ammoProjectileAmount);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalProjectileAmount.set(modifier.modifyProjectileAmount(finalProjectileAmount.get(), data)));
        return finalProjectileAmount.get();
    }

    public static int getReloadAmount(WeaponData data) {
        AtomicInteger value = new AtomicInteger(WeaponModifierHelper.getGeneral(data).getReloadAmount());
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyReloadAmount(value.get(), data)));
        return value.get();
    }

    public static int getMultishotAmount(WeaponData data) {
        AtomicInteger value = new AtomicInteger(WeaponModifierHelper.getGeneral(data).getMultishotAmount());
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyMultishotAmount(value.get(), data)));
        return value.get();
    }

    public static Set<FireMode> getFireModes(WeaponData data) {
        Set<FireMode> fireMode = WeaponModifierHelper.getGeneral(data).getFireModes();
        AtomicReference<Set<FireMode>> finalFireMode = new AtomicReference<Set<FireMode>>(fireMode);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalFireMode.set(modifier.modifyFireModes((Set)finalFireMode.get(), data)));
        return finalFireMode.get();
    }

    public static GripType getGripType(WeaponData data) {
        if (data.weapon == null) {
            return GripType.ONE_HANDED;
        }
        GripType gripType = WeaponModifierHelper.getGeneral(data).getGripType();
        AtomicReference<GripType> finalGripType = new AtomicReference<GripType>(gripType);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalGripType.set(modifier.modifyGripType((GripType)finalGripType.get(), data)));
        return finalGripType.get();
    }

    public static boolean isOneHanded(WeaponData data) {
        if (data.weapon.m_41720_() instanceof IWeapon) {
            AtomicReference<Boolean> value = new AtomicReference<Boolean>(WeaponModifierHelper.getGeneral(data).isOneHanded());
            WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyOneHanded((Boolean)value.get(), data)));
            return value.get();
        }
        return true;
    }

    public static int getFireDelay(WeaponData data) {
        AtomicInteger chargeTime = new AtomicInteger(WeaponModifierHelper.getGeneral(data).getFireDelay());
        WeaponModifierHelper.forEachAttachment(data, modifier -> chargeTime.set(modifier.modifyFireDelay(chargeTime.get(), data)));
        return chargeTime.get();
    }

    public static Fuel getFuel(ResourceLocation type, WeaponData data) {
        AtomicReference<Fuel> value = new AtomicReference<Fuel>(WeaponModifierHelper.getConfig(data).getFuelConfig(type));
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyFuel((Fuel)value.get(), data)));
        return value.get();
    }

    public static ResourceLocation getAnimation(AnimationType type, WeaponData data) {
        AtomicReference<ResourceLocation> value = new AtomicReference<ResourceLocation>(WeaponModifierHelper.getConfig(data).getAnimation(type));
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyAnimation(type, (ResourceLocation)value.get(), data)));
        return value.get();
    }

    public static boolean needsFullCharge(WeaponData data) {
        AtomicBoolean needsFullCharge = new AtomicBoolean(WeaponModifierHelper.getGeneral(data).isFullCharge());
        WeaponModifierHelper.forEachAttachment(data, modifier -> needsFullCharge.set(modifier.modifyNeedsFullCharge(needsFullCharge.get(), data)));
        return needsFullCharge.get();
    }

    public static boolean isOneTimeCharge(WeaponData data) {
        AtomicBoolean oneTimeCharge = new AtomicBoolean(WeaponModifierHelper.getGeneral(data).isOneTimeCharge());
        WeaponModifierHelper.forEachAttachment(data, modifier -> oneTimeCharge.set(modifier.modifyIsOneTimeCharge(oneTimeCharge.get(), data)));
        return oneTimeCharge.get();
    }

    public static boolean canShoot(WeaponData data) {
        WeaponAction value = WeaponModifierHelper.getWeaponAction(data);
        return value == WeaponAction.SHOT;
    }

    public static boolean canMelee(WeaponData data) {
        WeaponAction value = WeaponModifierHelper.getWeaponAction(data);
        return value == WeaponAction.MELEE;
    }

    public static boolean canThrow(WeaponData data) {
        WeaponAction value = WeaponModifierHelper.getWeaponAction(data);
        return value == WeaponAction.THROW;
    }

    public static int getPrepareTime(WeaponData data) {
        int items = WeaponModifierHelper.getThrowable(data).getPrepareTime();
        AtomicReference<Integer> value = new AtomicReference<Integer>(items);
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyPrepareTime((Integer)value.get(), data)));
        return value.get();
    }

    public static int getThrowTime(WeaponData data) {
        int items = WeaponModifierHelper.getThrowable(data).getThrowTime();
        AtomicReference<Integer> value = new AtomicReference<Integer>(items);
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyThrowTime((Integer)value.get(), data)));
        return value.get();
    }

    public static LinkedHashSet<ThrowMode> getThrowModes(WeaponData data) {
        AtomicReference<LinkedHashSet<ThrowMode>> value = new AtomicReference<LinkedHashSet<ThrowMode>>(WeaponModifierHelper.getThrowable(data).getThrowModes());
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyThrowModes((LinkedHashSet)value.get(), data)));
        return value.get();
    }

    public static Set<AmmoHolder> getAmmoItems(WeaponData data) {
        Set<AmmoHolder> items = WeaponModifierHelper.getGeneral(data).getAmmo();
        AtomicReference<Set<AmmoHolder>> value = new AtomicReference<Set<AmmoHolder>>(items);
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyAmmoItems((Set)value.get(), data)));
        return value.get();
    }

    public static Set<AmmoHolder> getAllFuel(WeaponData data) {
        Set<AmmoHolder> items = WeaponModifierHelper.getGeneral(data).getFuel();
        AtomicReference<Set<AmmoHolder>> weapon = new AtomicReference<Set<AmmoHolder>>(items);
        WeaponModifierHelper.forEachAttachment(data, modifier -> weapon.set(modifier.modifyFuelItems((Set)weapon.get(), data)));
        return weapon.get();
    }

    public static AmmoHolder getFirstAmmoItem(WeaponData data) {
        Set<AmmoHolder> items = WeaponModifierHelper.getAmmoItems(data);
        return items.iterator().next();
    }

    public static int getReloadStart(WeaponData data) {
        int reloadTime = WeaponModifierHelper.getGeneral(data).getReloadStart();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadStart(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getReloadTime(WeaponData data) {
        int reloadTime = WeaponModifierHelper.getGeneral(data).getReloadTime();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadTime(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getReloadEnd(WeaponData data) {
        int reloadTime = WeaponModifierHelper.getGeneral(data).getReloadEnd();
        AtomicInteger finalReloadTime = new AtomicInteger(reloadTime);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalReloadTime.set(modifier.modifyReloadEnd(finalReloadTime.get(), data)));
        return finalReloadTime.get();
    }

    public static int getEquipTime(WeaponData data) {
        int equipTime = WeaponModifierHelper.getGeneral(data).getEquipTime();
        AtomicInteger finalEquipTime = new AtomicInteger(equipTime);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalEquipTime.set(modifier.modifyEquipTime(finalEquipTime.get(), data)));
        return finalEquipTime.get();
    }

    public static int getAmmoPerShot(WeaponData data) {
        int value = WeaponModifierHelper.getGeneral(data).getAmmoPerShot();
        AtomicInteger finalEquipTime = new AtomicInteger(value);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalEquipTime.set(modifier.modifyAmmoPerShot(finalEquipTime.get(), data)));
        return finalEquipTime.get();
    }

    public static int getProjectileSpeed(WeaponData data, int life) {
        AtomicInteger finalLife = new AtomicInteger(life);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalLife.set(modifier.modifyProjectileLife(finalLife.get(), data)));
        return finalLife.get();
    }

    public static int getProjectileLife(WeaponData data, int life) {
        AtomicInteger finalLife = new AtomicInteger(life);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalLife.set(modifier.modifyProjectileLife(finalLife.get(), data)));
        return finalLife.get();
    }

    public static double getProjectileGravity(WeaponData data, double gravity) {
        AtomicReference<Double> finalGravity = new AtomicReference<Double>(gravity);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalGravity.set(modifier.modifyProjectileGravity((Double)finalGravity.get(), data)));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalGravity.updateAndGet(v -> v + modifier.additionalProjectileGravity(data)));
        return finalGravity.get();
    }

    public static float getSpread(WeaponData data) {
        float gunSpread = WeaponModifierHelper.getGeneral(data).getSpread();
        float ammoSpread = WeaponStateHelper.getProjectileConfig(data).getSpread();
        float spread = Math.max(gunSpread + ammoSpread, 0.0f);
        AtomicReference<Float> finalSpread = new AtomicReference<Float>(Float.valueOf(spread));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalSpread.set(Float.valueOf(modifier.modifyProjectileSpread(((Float)finalSpread.get()).floatValue(), data))));
        return finalSpread.get().floatValue();
    }

    public static float getMovementSpeed(WeaponData data) {
        float gunSpread = WeaponModifierHelper.getGeneral(data).getMovementSpeed();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(gunSpread));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMovementSpeed(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static float getFireSoundVolume(WeaponData data) {
        AtomicReference<Float> volume = new AtomicReference<Float>(Float.valueOf(1.0f));
        WeaponModifierHelper.forEachAttachment(data, modifier -> volume.set(Float.valueOf(modifier.modifyFireSoundVolume(((Float)volume.get()).floatValue(), data))));
        return Mth.m_14036_((float)volume.get().floatValue(), (float)0.0f, (float)16.0f);
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public static double getMuzzleFlashSize(WeaponData data, double size) {
        AtomicReference<Double> finalSize = new AtomicReference<Double>(size);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalSize.set(modifier.modifyMuzzleFlashSize((Double)finalSize.get(), data)));
        return finalSize.get();
    }

    public static float getRecoilModifier(WeaponData data) {
        AtomicReference<Float> recoilReduction = new AtomicReference<Float>(Float.valueOf(1.0f));
        WeaponModifierHelper.forEachAttachment(data, modifier -> recoilReduction.updateAndGet(v -> Float.valueOf(v.floatValue() * Mth.m_14036_((float)modifier.recoilModifier(data), (float)0.0f, (float)1.0f))));
        return 1.0f - recoilReduction.get().floatValue();
    }

    public static float getRecoilAngle(WeaponData data) {
        AtomicReference<Float> value = new AtomicReference<Float>(Float.valueOf(WeaponModifierHelper.getGeneral(data).getRecoilAngle()));
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(Float.valueOf(modifier.modifyRecoil(((Float)value.get()).floatValue(), data))));
        return 1.0f - value.get().floatValue();
    }

    public static boolean isSilencedFire(WeaponData data) {
        AtomicBoolean value = new AtomicBoolean(WeaponModifierHelper.getGeneral(data).isSilenced());
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.silencedFire(value.get(), data)));
        return value.get();
    }

    public static double getModifiedFireSoundRadius(WeaponData data, double radius) {
        AtomicReference<Double> minRadius = new AtomicReference<Double>(radius);
        WeaponModifierHelper.forEachAttachment(data, modifier -> {
            double newRadius = modifier.modifyFireSoundRadius(radius, data);
            if (newRadius < (Double)minRadius.get()) {
                minRadius.set(newRadius);
            }
        });
        return Mth.m_14008_((double)minRadius.get(), (double)0.0, (double)Double.MAX_VALUE);
    }

    public static float getProjectileDamage(ResourceLocation ammo, WeaponData data) {
        float damage = WeaponModifierHelper.getConfig(data).getProjectileConfig(ammo).getDamage();
        AtomicReference<Float> finalDamage = new AtomicReference<Float>(Float.valueOf(damage));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalDamage.set(Float.valueOf(modifier.modifyProjectileDamage(((Float)finalDamage.get()).floatValue(), ammo, data))));
        return finalDamage.get().floatValue();
    }

    public static double getModifiedAimDownSightSpeed(WeaponData data) {
        AtomicReference<Double> value = new AtomicReference<Double>(1.0);
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyAimDownSightSpeed((Double)value.get(), data)));
        return Mth.m_14008_((double)value.get(), (double)0.01, (double)Double.MAX_VALUE);
    }

    public static int getRate(WeaponData data) {
        AtomicInteger value = new AtomicInteger(WeaponModifierHelper.getGeneral(data).getRate());
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyFireRate(value.get(), data)));
        return Mth.m_14045_((int)value.get(), (int)0, (int)Integer.MAX_VALUE);
    }

    public static float getCriticalChance(WeaponData data) {
        AtomicReference<Float> chance = new AtomicReference<Float>(Float.valueOf(0.0f));
        WeaponModifierHelper.forEachAttachment(data, modifier -> chance.updateAndGet(v -> Float.valueOf(v.floatValue() + modifier.criticalChance(data))));
        return Mth.m_14036_((float)chance.get().floatValue(), (float)0.0f, (float)1.0f);
    }

    public static MeleeMode getMeleeMode(WeaponData data) {
        AtomicReference<MeleeMode> value = new AtomicReference<MeleeMode>(WeaponModifierHelper.getMelee(data).getMode());
        WeaponModifierHelper.forEachAttachment(data, modifier -> value.set(modifier.modifyMeleeMode((MeleeMode)value.get(), data)));
        return value.get();
    }

    public static int getMeleeCooldown(WeaponData data) {
        int time = WeaponModifierHelper.getMelee(data).getCooldown();
        AtomicInteger finalTime = new AtomicInteger(time);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalTime.set(modifier.modifyMeleeCooldown(finalTime.get(), data)));
        return finalTime.get();
    }

    public static int getMeleeDelay(WeaponData data) {
        int time = WeaponModifierHelper.getMelee(data).getDelay();
        AtomicInteger finalTime = new AtomicInteger(time);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalTime.set(modifier.modifyMeleeDelay(finalTime.get(), data)));
        return finalTime.get();
    }

    public static int getMeleeMaxTargets(WeaponData data) {
        int time = WeaponModifierHelper.getMelee(data).getMaxTargets();
        AtomicInteger finalTime = new AtomicInteger(time);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalTime.set(modifier.modifyMeleeMaxTargets(finalTime.get(), data)));
        return finalTime.get();
    }

    public static float getMeleeDamage(WeaponData data) {
        float value = WeaponModifierHelper.getMelee(data).getDamage();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(value));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMeleeDamage(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static float getMeleeDistance(WeaponData data) {
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(WeaponModifierHelper.getMelee(data).getDistance()));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMeleeDistance(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static float getMeleeAngle(WeaponData data) {
        float value = WeaponModifierHelper.getMelee(data).getAngle();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(value));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMeleeAngle(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static float getMeleeKnockback(WeaponData data) {
        float value = WeaponModifierHelper.getMelee(data).getKnockback();
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(value));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyMeleeKnockback(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static float getFovModifier(WeaponData data) {
        AtomicReference<Float> finalValue = new AtomicReference<Float>(Float.valueOf(WeaponModifierHelper.getZoom(data).getFovModifier()));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(Float.valueOf(modifier.modifyFov(((Float)finalValue.get()).floatValue(), data))));
        return finalValue.get().floatValue();
    }

    public static Vec3 getSightOffset(WeaponData data) {
        AtomicReference<Vec3> finalValue = new AtomicReference<Vec3>(WeaponModifierHelper.getZoom(data).getOffset());
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifySightOffset((Vec3)finalValue.get(), data)));
        return finalValue.get();
    }

    public static ProjectileConfig getProjectileConfig(ResourceLocation ammoId, WeaponData data) {
        Object object;
        WeaponConfig gun = WeaponModifierHelper.getConfig(data);
        ProjectileConfig config = null;
        AmmoHolder item = WeaponStateHelper.getCurrentAmmoWithoutCheck(data);
        if (gun.hasAmmo(ammoId)) {
            config = gun.getProjectileConfig(ammoId);
        } else if (item.canReturnAmmo() && (object = ForgeRegistries.ITEMS.getValue(item.getId())) instanceof IAmmo) {
            IAmmo ammoItem = (IAmmo)object;
            config = ammoItem.getAmmo();
        }
        if (config == null) {
            config = new ProjectileConfig();
        }
        AtomicReference<ProjectileConfig> finalValue = new AtomicReference<ProjectileConfig>(config);
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyProjectile((ProjectileConfig)finalValue.get(), data)));
        return finalValue.get();
    }

    public static AmmoConfig getAmmoConfig(ResourceLocation ammoId, WeaponData data) {
        AtomicReference<AmmoConfig> finalValue = new AtomicReference<AmmoConfig>(WeaponModifierHelper.getConfig(data).getAmmoConfig(ammoId));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyAmmo((AmmoConfig)finalValue.get(), data)));
        return finalValue.get();
    }

    public static AmmoConfig getFuelAmmoConfig(ResourceLocation ammoId, WeaponData data) {
        AtomicReference<AmmoConfig> finalValue = new AtomicReference<AmmoConfig>(WeaponModifierHelper.getConfig(data).getFuelAmmoConfig(ammoId));
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyFuelAmmo((AmmoConfig)finalValue.get(), data)));
        return finalValue.get();
    }

    public static Integer getMaxFuel(ResourceLocation type, WeaponData data) {
        Fuel fuel = WeaponModifierHelper.getFuel(type, data);
        int max = fuel != null ? fuel.getMax() : 0;
        AtomicReference<Integer> result = new AtomicReference<Integer>(max);
        WeaponModifierHelper.forEachAttachment(data, modifier -> result.set(modifier.modifyMaxFuel(type, (Integer)result.get(), data)));
        return result.get();
    }

    public static boolean isFuelMandatory(ResourceLocation ammoId, WeaponData data) {
        AtomicReference<Boolean> finalValue = new AtomicReference<Boolean>(WeaponModifierHelper.getConfig(data).getFuelConfig(ammoId).isMandatory());
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyIsFuelMandatory(ammoId, (Boolean)finalValue.get(), data)));
        return finalValue.get();
    }

    public static int getFuelAmountPerUse(ResourceLocation ammoId, WeaponData data) {
        AtomicReference<Integer> finalValue = new AtomicReference<Integer>(WeaponModifierHelper.getConfig(data).getFuelConfig(ammoId).getAmountPerUse());
        WeaponModifierHelper.forEachAttachment(data, modifier -> finalValue.set(modifier.modifyFuelAmountPerUse(ammoId, (Integer)finalValue.get(), data)));
        return finalValue.get();
    }

    private static void forEachAttachment(WeaponData data, Consumer<IWeaponModifier> consumer) {
        ItemStack weapon = data.weapon;
        WeaponConfig config = WeaponModifierHelper.getConfig(data);
        LinkedHashMap<AttachmentType, ArrayList<Modules.Attachment>> attachments = config.getModules().getAttachments();
        for (AttachmentType attachmentType : attachments.keySet()) {
            IWeaponModifier[] modifiers;
            ItemStack attachmentItem;
            data.attachment = attachmentItem = WeaponStateHelper.getAttachmentItem(attachmentType, weapon);
            for (IWeaponModifier modifier : modifiers = WeaponModifierHelper.getAttachmentModifiers(attachmentItem)) {
                consumer.accept(modifier);
            }
        }
        IWeaponModifier[] iWeaponModifierArray = weapon.m_41720_();
        if (iWeaponModifierArray instanceof IWeapon) {
            IWeapon weaponItem = (IWeapon)iWeaponModifierArray;
            for (IWeaponModifier modifier : weaponItem.getModifiers()) {
                consumer.accept(modifier);
            }
        }
    }

    private static IWeaponModifier[] getAttachmentModifiers(ItemStack attachmentItem) {
        Item item;
        if (!attachmentItem.m_41619_() && (item = attachmentItem.m_41720_()) instanceof IAttachment) {
            IAttachment attachment = (IAttachment)item;
            Object[] modifiers = ((Attachment)attachment.getProperties()).getModifiers();
            Modifiers configModifiers = attachment.getAttachmentConfig().getModifiers();
            return (IWeaponModifier[])ArrayUtils.add((Object[])modifiers, (Object)configModifiers);
        }
        return EMPTY;
    }

    public static boolean isWeaponItem(ItemStack mainHandItem) {
        return mainHandItem.m_41720_() instanceof IWeapon;
    }
}

