/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.gunpack.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.foundation.item.AmmoItem;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.foundation.item.attachment.GenericAttachmentItem;
import com.nukateam.ntgl.common.util.helpers.RegistrationHelper;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import com.nukateam.ntgl.modules.gunpack.GunPackModule;
import com.nukateam.ntgl.modules.gunpack.regestry.ModBlocks;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.BlockEntitySignTextStrictJsonFix;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GunRegisterer {
    private static final String REGISTRY_FILE = "registry.json";
    private static final Pattern CONFIG_PATTERN = Pattern.compile("^data/([^/]+)/weapons/([^/]+\\.json)$");
    private static final Pattern RECIPE_PATTERN = Pattern.compile("^data/([^/]+)/recipes/([^/]+\\.json)$");
    private static final Map<String, DeferredRegister<Item>> ITEMS = new HashMap<String, DeferredRegister<Item>>();
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"ntgl");
    private static final Map<String, Set<String>> MOD_CONFIGS = new HashMap<String, Set<String>>();
    private static boolean hasValidRecipe = false;

    public static void init(IEventBus eventBus) {
        GunRegisterer.processArchives();
        GunRegisterer.registerGunTab();
        ITEMS.forEach((k, gunRegister) -> gunRegister.register(eventBus));
        CREATIVE_MODE_TABS.register(eventBus);
    }

    private static void registerGunTab() {
        if (hasValidRecipe) {
            GunRegisterer.createBlockTab(CREATIVE_MODE_TABS);
        }
        ITEMS.forEach((id, gunRegister) -> GunRegisterer.createTab(CREATIVE_MODE_TABS, id, (DeferredRegister<Item>)gunRegister));
    }

    @Nullable
    private static void createBlockTab(DeferredRegister<CreativeModeTab> creativeModeTabs) {
        creativeModeTabs.register("ntgl_blocks", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ModBlocks.WORKBENCH.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.ntgl.blocks")).m_257501_((params, output) -> output.m_246326_((ItemLike)ModBlocks.WORKBENCH.get())).m_257652_());
    }

    private static void createTab(DeferredRegister<CreativeModeTab> creativeModeTabs, String namespace, DeferredRegister<Item> gunRegister) {
        Collection items = gunRegister.getEntries();
        if (!items.isEmpty()) {
            creativeModeTabs.register(namespace, () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)((RegistryObject)items.stream().findFirst().get()).get())).m_257941_((Component)Component.m_237115_((String)("itemGroup." + namespace))).m_257501_((params, output) -> {
                for (RegistryObject entry : gunRegister.getEntries()) {
                    RegistrationHelper.registerGunOrDefault(output, (Item)entry.get());
                }
            }).m_257652_());
        }
    }

    public static void processArchives() {
        Path ntglPath = Paths.get("ntgl", new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(ntglPath, "*.zip");){
            for (Path zipFile : stream) {
                GunRegisterer.processPack(zipFile);
                GunRegisterer.processZipArchive(zipFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void processZipArchive(Path zipPath) {
        try (ZipFile zip = new ZipFile(zipPath.toFile());){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || hasValidRecipe || !GunRegisterer.isValidRecipe(entry, zip)) continue;
                hasValidRecipe = true;
            }
        }
        catch (IOException e) {
            GunPackModule.LOGGER.error("Error processing archive: {}", (Object)zipPath, (Object)e);
        }
    }

    private static void processPack(Path packPath) {
        try (ZipFile zip = new ZipFile(packPath.toFile());){
            ZipEntry manifest = zip.getEntry(REGISTRY_FILE);
            if (manifest == null) {
                return;
            }
            JsonObject manifestJson = (JsonObject)BlockEntitySignTextStrictJsonFix.f_14861_.fromJson((Reader)new InputStreamReader(zip.getInputStream(manifest)), JsonObject.class);
            GunRegisterer.registerItems(manifestJson, "weapons", GunRegisterer::registerGun);
            GunRegisterer.registerItems(manifestJson, "attachments", GunRegisterer::registerAttachment);
            GunRegisterer.registerItems(manifestJson, "ammo", GunRegisterer::registerAmmo);
        }
        catch (Exception e) {
            GunPackModule.LOGGER.error("Error processing pack: {}", (Object)packPath.getFileName(), (Object)e);
            e.printStackTrace();
        }
    }

    private static void registerItems(JsonObject manifestJson, String name, Consumer<ResourceLocation> consumer) {
        JsonArray guns = manifestJson.getAsJsonArray(name);
        guns.forEach(item -> {
            ResourceLocation id = ResourceLocation.m_135820_((String)item.getAsString());
            if (id != null && !ForgeRegistries.ITEMS.containsKey(id)) {
                consumer.accept(id);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidRecipe(ZipEntry entry, ZipFile zip) {
        try {
            Matcher pathMatcher = RECIPE_PATTERN.matcher(entry.getName());
            if (!pathMatcher.matches()) {
                return false;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));){
                String line;
                do {
                    if ((line = reader.readLine()) == null) return false;
                } while (!line.contains("\"type\": \"ntgl:workbench\""));
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ex) {
            System.err.println("Error reading recipe: " + entry.getName());
        }
        return false;
    }

    @NotNull
    private static DeferredRegister<Item> getItemRegister(ResourceLocation itemId) {
        return ITEMS.computeIfAbsent(itemId.m_135827_(), id -> DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)id));
    }

    private static void registerGun(ResourceLocation itemId) {
        GunRegisterer.getItemRegister(itemId).register(itemId.m_135815_(), () -> new WeaponItem(new Item.Properties().m_41487_(1), new IWeaponModifier[0]));
    }

    private static void registerAttachment(ResourceLocation itemId) {
        GunRegisterer.getItemRegister(itemId).register(itemId.m_135815_(), () -> new GenericAttachmentItem(new Item.Properties().m_41487_(1)));
    }

    private static void registerAmmo(ResourceLocation itemId) {
        GunRegisterer.getItemRegister(itemId).register(itemId.m_135815_(), () -> new AmmoItem(new Item.Properties(), new IWeaponModifier[0]));
    }
}

