/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.chassis_core.client.render.layers.LayerBase;
import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.foundation.entity.Chassis;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.foundation.item.ChassisEquipment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;

public class EquipmentLayer<T extends WearableChassis>
extends LayerBase<T> {
    public EquipmentLayer(GeoRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, T entity, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        for (ChassisPart part : ((Chassis)((Object)entity)).getEquipment()) {
            if (!((Chassis)((Object)entity)).isEquipmentVisible(part)) continue;
            ItemStack stack = ((Chassis)((Object)entity)).getEquipment(part);
            ChassisEquipment item = ((WearableChassis)((Object)entity)).getEquipmentItem(part);
            if (item.getConfig() == null) {
                return;
            }
            ResourceLocation texture = item.getTexture(stack);
            if (texture == null) {
                return;
            }
            this.renderLayer(poseStack, entity, bakedModel, bufferSource, partialTick, packedLight, texture);
        }
    }
}

