/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.helpers;

import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.util.helpers.compatibility.PlayerAnimationHelper;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerAnimations {
    public static void playFireAnimation(Player player, InteractionHand hand) {
        if (Ntgl.playerAnimatorLoaded) {
            WeaponData gunData = new WeaponData(player.m_21120_(hand), (LivingEntity)Minecraft.m_91087_().f_91074_);
            int rate = WeaponModifierHelper.getRate(gunData);
            ResourceLocation animation = WeaponModifierHelper.getAnimation(AnimationType.FIRE, gunData);
            PlayerAnimationHelper.playAnim((Player)((AbstractClientPlayer)player), animation, rate, hand == InteractionHand.OFF_HAND);
        }
    }

    public static void playMeleeAnimation(Player player, InteractionHand hand) {
        if (Ntgl.playerAnimatorLoaded) {
            WeaponData gunData = new WeaponData(player.m_21120_(hand), (LivingEntity)Minecraft.m_91087_().f_91074_);
            int delay = WeaponModifierHelper.getMeleeDelay(gunData);
            int cooldown = WeaponModifierHelper.getMeleeCooldown(gunData);
            ResourceLocation animation = WeaponModifierHelper.getAnimation(AnimationType.MELEE, gunData);
            PlayerAnimationHelper.playAnim((Player)((AbstractClientPlayer)player), animation, delay + cooldown, hand == InteractionHand.OFF_HAND);
        }
    }

    public static void playReloadAnimation(Player player, InteractionHand hand) {
        if (Ntgl.playerAnimatorLoaded) {
            int reloadDuration = 0;
            WeaponData gunData = new WeaponData(player.m_21120_(hand), (LivingEntity)player);
            int reloadTime = WeaponModifierHelper.getReloadTime(gunData);
            LoadingType loadingType = WeaponModifierHelper.getLoadingType(gunData);
            if (loadingType.equals(LoadingType.PER_CARTRIDGE)) {
                int ammoCount = WeaponModifierHelper.getMaxAmmo(gunData) - WeaponStateHelper.getAmmoCount(gunData);
                for (int i = 0; i < ammoCount; ++i) {
                    reloadDuration += reloadTime;
                }
            } else {
                reloadDuration = reloadTime;
            }
            ResourceLocation reloadAnimation = WeaponModifierHelper.getAnimation(AnimationType.RELOAD, gunData);
            PlayerAnimationHelper.playAnim((Player)((AbstractClientPlayer)player), reloadAnimation, reloadDuration, hand == InteractionHand.OFF_HAND);
        }
    }
}

