/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.weapon.AmmoConfig;
import com.nukateam.ntgl.common.data.config.weapon.AmmoData;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class ThrowableConfig
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String PREPARE_TIME = "prepareTime";
    public static final String THROW_TIME = "throwTime";
    public static final String AMMO_DATA = "AmmoData";
    @Optional
    LinkedHashSet<ThrowMode> mode = new LinkedHashSet<ThrowMode>(List.of(ThrowMode.SAFE));
    private int prepareTime = 0;
    private int throwTime = 1;
    protected AmmoData ammoData = new AmmoData();

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("mode", (Tag)NbtUtils.serializeSet(this.mode));
        tag.m_128405_(PREPARE_TIME, this.prepareTime);
        tag.m_128405_(THROW_TIME, this.throwTime);
        tag.m_128365_(AMMO_DATA, (Tag)this.ammoData.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("mode", 10)) {
            this.mode = NbtUtils.deserializeSet(tag.m_128469_("mode"), ThrowMode::getType);
        }
        if (tag.m_128425_(PREPARE_TIME, 3)) {
            this.prepareTime = tag.m_128451_(PREPARE_TIME);
        }
        if (tag.m_128425_(THROW_TIME, 3)) {
            this.throwTime = tag.m_128451_(THROW_TIME);
        }
        if (tag.m_128425_(AMMO_DATA, 10)) {
            this.ammoData = AmmoData.create(tag.m_128469_(AMMO_DATA));
        }
    }

    public JsonObject toJsonObject() {
        Gson gson = new Gson();
        JsonObject object = new JsonObject();
        object.addProperty("mode", this.mode.toString());
        object.addProperty(PREPARE_TIME, (Number)this.prepareTime);
        object.addProperty(THROW_TIME, (Number)this.throwTime);
        object.add("projectile", (JsonElement)this.ammoData.toJsonObject());
        return object;
    }

    public ThrowableConfig copy() {
        ThrowableConfig config = new ThrowableConfig();
        config.mode = (LinkedHashSet)this.mode.clone();
        config.prepareTime = this.prepareTime;
        config.throwTime = this.throwTime;
        config.ammoData = this.ammoData;
        return config;
    }

    public ProjectileConfig getProjectile() {
        return this.ammoData.getProjectile();
    }

    public AmmoConfig getAmmo() {
        return this.ammoData.getAmmo();
    }

    private HashMap<String, ResourceLocation> deserializeSounds(CompoundTag tag) {
        HashMap<String, ResourceLocation> result = new HashMap<String, ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            result.put(key, this.createSound(tag, key));
        }
        return result;
    }

    private ResourceLocation createSound(CompoundTag tag, String key) {
        String sound = tag.m_128461_(key);
        return sound.isEmpty() ? null : ResourceLocation.m_135820_((String)sound);
    }

    public int getPrepareTime() {
        return this.prepareTime;
    }

    public int getThrowTime() {
        return this.throwTime;
    }

    public LinkedHashSet<ThrowMode> getThrowModes() {
        return this.mode;
    }

    public static ThrowableConfig create(ResourceLocation id, CompoundTag tag) {
        ThrowableConfig gun = new ThrowableConfig();
        gun.deserializeNBT(tag);
        return gun;
    }

    public void onCreated(String id) {
    }

    public static class Builder {
        private final ThrowableConfig gun;

        private Builder() {
            this.gun = new ThrowableConfig();
        }

        private Builder(ThrowableConfig gun) {
            this.gun = gun.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(ThrowableConfig gun) {
            return new Builder(gun);
        }

        public ThrowableConfig build() {
            return this.gun.copy();
        }
    }
}

