/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.registry;

import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;

public class AmmoHolders {
    public static final AmmoHolder BURNABLE = AmmoHolder.Builder.create(Ntgl.ntglResource("burnable")).isAcceptable(AmmoHolders::isBurnable).value(stack -> ForgeHooks.getBurnTime((ItemStack)stack, null)).onConsume(AmmoHolders::consumeBurnable).build();
    public static final AmmoHolder WATER = AmmoHolder.Builder.create(Ntgl.ntglResource("water")).isAcceptable(AmmoHolders::isWater).value(stack -> 1000).onConsume(AmmoHolders::consumeWater).build();

    public static void register() {
        AmmoHolder.registerType(BURNABLE);
        AmmoHolder.registerType(WATER);
    }

    public static boolean isBurnable(ItemStack ammoStack) {
        int burnTime = ForgeHooks.getBurnTime((ItemStack)ammoStack, null);
        return burnTime > 0;
    }

    public static boolean isWater(ItemStack ammoStack) {
        return ammoStack.m_41720_() == Items.f_42447_;
    }

    public static List<ItemStack> consumeBurnable(ItemStack stack, Integer i) {
        if (stack.m_41720_() == Items.f_42448_) {
            return List.of(new ItemStack((ItemLike)Items.f_42446_));
        }
        return List.of();
    }

    public static List<ItemStack> consumeWater(ItemStack stack, Integer i) {
        if (stack.m_41720_() == Items.f_42447_) {
            return List.of(new ItemStack((ItemLike)Items.f_42446_));
        }
        return List.of();
    }
}

